/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.jdkclient;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.jdkclient.JdkHttpClient;
import org.jolokia.client.spi.HttpClientBuilder;
import org.jolokia.client.spi.HttpClientSpi;

public class JdkHttpClientBuilder
implements HttpClientBuilder<HttpClient> {
    @Override
    public HttpClientSpi<HttpClient> buildHttpClient(JolokiaClientBuilder.Configuration jcb) {
        JolokiaClientBuilder.Proxy httpProxy;
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).cookieHandler(new CookieManager()).priority(1);
        if (jcb.tlsConfig() != null && jcb.tlsConfig().protocolVersion() != null) {
            try {
                builder.sslContext(this.createSSLContest(jcb.tlsConfig()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Problem with TLS configuration: " + e.getMessage(), e);
            }
        }
        if (jcb.connectionConfig().connectionTimeout() != -1) {
            builder.connectTimeout(Duration.ofMillis(jcb.connectionConfig().connectionTimeout()));
        }
        if ((httpProxy = jcb.proxy()) != null) {
            builder.proxy(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    return List.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxy.getHost(), httpProxy.getPort())));
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
        }
        if (jcb.customizer() != null) {
            Class<?> builderClass = jcb.clientBuilderClass();
            if (!builderClass.isAssignableFrom(builder.getClass())) {
                throw new IllegalArgumentException("Unsupported class for JDK Client builder associated with the customizer: " + builderClass.getName());
            }
            jcb.customizer().accept(builder);
        }
        return new JdkHttpClient(builder.build(), jcb);
    }

    private SSLContext createSSLContest(JolokiaClientBuilder.TlsConfiguration tlsConfiguration) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException {
        FileInputStream fis;
        KeyStore ks;
        if (tlsConfiguration.protocolVersion() == null) {
            return null;
        }
        SSLContext context = SSLContext.getInstance(tlsConfiguration.protocolVersion());
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        if (tlsConfiguration.keystore() != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(tlsConfiguration.keystore().toFile());
            try {
                ks.load(fis, tlsConfiguration.keystorePassword() == null ? new char[]{} : tlsConfiguration.keystorePassword().toCharArray());
                kmf.init(ks, tlsConfiguration.keyPassword() == null ? new char[]{} : tlsConfiguration.keyPassword().toCharArray());
            }
            finally {
                fis.close();
            }
            keyManagers = kmf.getKeyManagers();
        }
        if (tlsConfiguration.truststore() != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(tlsConfiguration.truststore().toFile());
            try {
                ks.load(fis, tlsConfiguration.truststorePassword() == null ? new char[]{} : tlsConfiguration.truststorePassword().toCharArray());
                tmf.init(ks);
            }
            finally {
                fis.close();
            }
            trustManagers = tmf.getTrustManagers();
        }
        context.init(keyManagers, trustManagers, SecureRandom.getInstance("SHA1PRNG"));
        return context;
    }
}

