/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.jolokia.client.JolokiaQueryParameter;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.request.HttpMethod;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.json.parser.JSONParser;
import org.jolokia.json.parser.ParseException;

public class HttpUtil {
    public static String toQueryString(Map<JolokiaQueryParameter, String> pProcessingOptions) {
        if (pProcessingOptions != null && !pProcessingOptions.isEmpty()) {
            StringBuilder queryParams = new StringBuilder();
            for (Map.Entry<JolokiaQueryParameter, String> entry : pProcessingOptions.entrySet()) {
                queryParams.append(entry.getKey().getParam()).append("=").append(entry.getValue()).append("&");
            }
            return queryParams.substring(0, queryParams.length() - 1);
        }
        return null;
    }

    public static JSONStructure parseJsonResponse(InputStream body, Charset charset) throws ParseException, IOException {
        JSONParser parser = new JSONParser();
        return (JSONStructure)parser.parse((Reader)new InputStreamReader(body, charset));
    }

    public static <REQ extends JolokiaRequest> JolokiaTargetConfig determineTargetConfig(REQ pRequest, JolokiaTargetConfig pTargetConfig) {
        JolokiaTargetConfig targetConfig = pRequest.getTargetConfig();
        if (targetConfig == null) {
            targetConfig = pTargetConfig;
        }
        return targetConfig;
    }

    public static <REQ extends JolokiaRequest> HttpMethod determineHttpMethod(REQ pRequest, HttpMethod method, JolokiaTargetConfig targetConfig) {
        if (method == null) {
            method = pRequest.getPreferredHttpMethod();
        }
        if (method == null) {
            method = targetConfig != null ? HttpMethod.POST : HttpMethod.GET;
        }
        return method;
    }

    public static String prepareBaseUrl(URI jolokiaAgentUrl) {
        String base = jolokiaAgentUrl.getPath();
        if (base == null) {
            return "/";
        }
        if (!base.endsWith("/")) {
            return base + "/";
        }
        return base;
    }

    public static URI prepareFullUrl(URI jolokiaAgentUrl, String path, String queryParams) {
        try {
            return new URI(jolokiaAgentUrl.getScheme(), jolokiaAgentUrl.getUserInfo(), jolokiaAgentUrl.getHost(), jolokiaAgentUrl.getPort(), path, queryParams, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static JSONObject getJsonRequestContent(JolokiaRequest pRequest, JolokiaTargetConfig pTargetConfig) {
        JSONObject requestContent = pRequest.toJson();
        if (pTargetConfig != null) {
            requestContent.put((Object)"target", (Object)pTargetConfig.toJson());
        }
        return requestContent;
    }
}

