/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.exception;

import org.jolokia.client.exception.JolokiaException;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.json.JSONObject;

public class JolokiaRemoteException
extends JolokiaException {
    private final int status;
    private final String remoteStacktrace;
    private final JolokiaRequest request;
    private final String errorType;
    private final JSONObject errorValue;
    private JSONObject response;

    public JolokiaRemoteException(JolokiaRequest pJolokiaRequest, String pMessage, String pErrorType, int pStatus, String pStacktrace, JSONObject pErrorValue) {
        super(pMessage);
        this.status = pStatus;
        this.errorType = pErrorType;
        this.remoteStacktrace = pStacktrace;
        this.request = pJolokiaRequest;
        this.errorValue = pErrorValue;
    }

    public JolokiaRemoteException(JolokiaRequest pJolokiaRequest, JSONObject pJsonRespObject) {
        super(JolokiaRemoteException.generateErrorMessage(pJolokiaRequest, pJsonRespObject));
        int n;
        Object statusO = pJsonRespObject.get((Object)"status");
        if (statusO instanceof Number) {
            Number n2 = (Number)statusO;
            n = n2.intValue();
        } else {
            n = 500;
        }
        this.status = n;
        this.request = pJolokiaRequest;
        this.response = pJsonRespObject;
        this.errorType = (String)pJsonRespObject.get((Object)"error_type");
        this.remoteStacktrace = (String)pJsonRespObject.get((Object)"stacktrace");
        this.errorValue = (JSONObject)pJsonRespObject.get((Object)"error_value");
    }

    private static String generateErrorMessage(JolokiaRequest pJolokiaRequest, JSONObject pJsonRespObject) {
        if (pJsonRespObject.get((Object)"error") != null) {
            return "Error: " + String.valueOf(pJsonRespObject.get((Object)"error"));
        }
        Object o = pJsonRespObject.get((Object)"status");
        if (o != null && !(o instanceof Number)) {
            return "Invalid status of type " + o.getClass().getName() + " ('" + String.valueOf(o) + "') received. Expected a number.";
        }
        return "Invalid response received";
    }

    public String getErrorType() {
        return this.errorType;
    }

    public int getStatus() {
        return this.status;
    }

    public String getRemoteStackTrace() {
        return this.remoteStacktrace;
    }

    public JolokiaRequest getRequest() {
        return this.request;
    }

    public JSONObject getErrorValue() {
        return this.errorValue;
    }

    public JSONObject getResponse() {
        return this.response;
    }
}

