/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.client.request.AbtractJ4pMBeanRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pTargetConfig;
import org.jolokia.client.request.J4pType;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public class J4pExecRequest
extends AbtractJ4pMBeanRequest {
    private final String operation;
    private final List<Object> arguments;

    public J4pExecRequest(ObjectName pMBeanName, String pOperation, Object ... pArgs) {
        this(null, pMBeanName, pOperation, pArgs);
    }

    public J4pExecRequest(J4pTargetConfig pTargetConfig, ObjectName pMBeanName, String pOperation, Object ... pArgs) {
        super(J4pType.EXEC, pMBeanName, pTargetConfig);
        this.operation = pOperation;
        if (pArgs == null) {
            this.arguments = new ArrayList<Object>();
            this.arguments.add(null);
        } else {
            this.arguments = Arrays.asList(pArgs);
        }
    }

    public J4pExecRequest(String pMBeanName, String pOperation, Object ... pArgs) throws MalformedObjectNameException {
        this(null, pMBeanName, pOperation, pArgs);
    }

    public J4pExecRequest(J4pTargetConfig pTargetConfig, String pMBeanName, String pOperation, Object ... pArgs) throws MalformedObjectNameException {
        this(pTargetConfig, new ObjectName(pMBeanName), pOperation, pArgs);
    }

    public String getOperation() {
        return this.operation;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    J4pExecResponse createResponse(JSONObject pResponse) {
        return new J4pExecResponse(this, pResponse);
    }

    @Override
    List<String> getRequestParts() {
        List<String> ret = super.getRequestParts();
        ret.add(this.operation);
        if (!this.arguments.isEmpty()) {
            for (Object argument : this.arguments) {
                ret.add(this.serializeArgumentToRequestPart(argument));
            }
        }
        return ret;
    }

    @Override
    JSONObject toJson() {
        JSONObject ret = super.toJson();
        ret.put((Object)"operation", (Object)this.operation);
        if (!this.arguments.isEmpty()) {
            JSONArray args = new JSONArray(this.arguments.size());
            for (Object arg : this.arguments) {
                args.add(this.serializeArgumentToJson(arg));
            }
            ret.put((Object)"arguments", (Object)args);
        }
        return ret;
    }
}

