/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.J4pClientBuilderFactory;
import org.jolokia.client.exception.J4pBulkRemoteException;
import org.jolokia.client.exception.J4pConnectException;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.exception.J4pTimeoutException;
import org.jolokia.client.request.J4pQueryParameter;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pRequestHandler;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pTargetConfig;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J4pClient
extends J4pClientBuilderFactory {
    private HttpClient httpClient;
    private J4pRequestHandler requestHandler;

    public J4pClient(String pJ4pServerUrl) {
        this(pJ4pServerUrl, null);
    }

    public J4pClient(String pJ4pServerUrl, HttpClient pHttpClient) {
        this(pJ4pServerUrl, pHttpClient, null);
    }

    public J4pClient(String pJ4pServerUrl, HttpClient pHttpClient, J4pTargetConfig pTargetConfig) {
        this.requestHandler = new J4pRequestHandler(pJ4pServerUrl, pTargetConfig);
        if (pHttpClient != null) {
            this.httpClient = pHttpClient;
        } else {
            J4pClientBuilder builder = new J4pClientBuilder();
            HttpParams params = builder.getHttpParams();
            ClientConnectionManager cm = builder.createClientConnectionManager();
            this.httpClient = new DefaultHttpClient(cm, params);
        }
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> R execute(T pRequest) throws J4pException {
        return this.execute(pRequest, null, null);
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> R execute(T pRequest, Map<J4pQueryParameter, String> pProcessingOptions) throws J4pException {
        return this.execute(pRequest, null, pProcessingOptions);
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> R execute(T pRequest, String pMethod) throws J4pException {
        return this.execute(pRequest, pMethod, null);
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> R execute(T pRequest, String pMethod, Map<J4pQueryParameter, String> pProcessingOptions) throws J4pException {
        try {
            HttpResponse response = this.httpClient.execute(this.requestHandler.getHttpRequest(pRequest, pMethod, pProcessingOptions));
            JSONAware jsonResponse = this.extractJsonResponse(pRequest, response);
            if (!(jsonResponse instanceof JSONObject)) {
                throw new J4pException("Invalid JSON answer for a single request (expected a map but got a " + jsonResponse.getClass() + ")");
            }
            JSONObject jsonResponseObject = (JSONObject)jsonResponse;
            J4pRemoteException exp = this.validate(pRequest, jsonResponseObject);
            if (exp == null) {
                return this.requestHandler.extractResponse(pRequest, jsonResponseObject);
            }
            throw exp;
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
        catch (URISyntaxException e) {
            throw this.mapException(e);
        }
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> List<R> execute(List<T> pRequests) throws J4pException {
        return this.execute(pRequests, null);
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> List<R> execute(List<T> pRequests, Map<J4pQueryParameter, String> pProcessingOptions) throws J4pException {
        try {
            HttpResponse response = this.httpClient.execute(this.requestHandler.getHttpRequest(pRequests, pProcessingOptions));
            JSONAware jsonResponse = this.extractJsonResponse(null, response);
            this.verifyBulkJsonResponse(jsonResponse);
            return this.extractResponses(jsonResponse, pRequests);
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
        catch (URISyntaxException e) {
            throw this.mapException(e);
        }
    }

    private <T extends J4pRequest> JSONAware extractJsonResponse(T pRequest, HttpResponse pResponse) throws J4pException {
        try {
            return this.requestHandler.extractJsonResponse(pResponse);
        }
        catch (IOException e) {
            throw new J4pException("IO-Error while reading the response: " + e, e);
        }
        catch (ParseException e) {
            StatusLine statusLine = pResponse.getStatusLine();
            if (200 != statusLine.getStatusCode()) {
                throw new J4pRemoteException(pRequest, statusLine.getReasonPhrase(), null, statusLine.getStatusCode(), null);
            }
            throw new J4pException("Could not parse answer: " + (Object)((Object)e), e);
        }
    }

    private <R extends J4pResponse<T>, T extends J4pRequest> List<R> extractResponses(JSONAware pJsonResponse, List<T> pRequests) throws J4pException {
        JSONArray responseArray = (JSONArray)pJsonResponse;
        ArrayList ret = new ArrayList(responseArray.size());
        J4pRemoteException[] remoteExceptions = new J4pRemoteException[responseArray.size()];
        boolean exceptionFound = false;
        for (int i = 0; i < pRequests.size(); ++i) {
            J4pRequest request = (J4pRequest)pRequests.get(i);
            Object jsonResp = responseArray.get(i);
            if (!(jsonResp instanceof JSONObject)) {
                throw new J4pException("Response for request Nr. " + i + " is invalid (expected a map but got " + jsonResp.getClass() + ")");
            }
            JSONObject jsonRespObject = (JSONObject)jsonResp;
            J4pRemoteException exp = this.validate(request, jsonRespObject);
            if (exp != null) {
                remoteExceptions[i] = exp;
                exceptionFound = true;
                ret.add(i, null);
                continue;
            }
            ret.add(i, this.requestHandler.extractResponse(request, (JSONObject)jsonResp));
        }
        if (exceptionFound) {
            ArrayList<J4pRemoteException> partialResults = new ArrayList<J4pRemoteException>();
            for (int i = 0; i < pRequests.size(); ++i) {
                J4pRemoteException exp = remoteExceptions[i];
                if (exp != null) {
                    partialResults.add(exp);
                    continue;
                }
                partialResults.add((J4pRemoteException)ret.get(i));
            }
            throw new J4pBulkRemoteException(partialResults);
        }
        return ret;
    }

    private J4pException mapException(Exception pException) throws J4pException {
        if (pException instanceof ConnectException) {
            return new J4pConnectException("Cannot connect to " + this.requestHandler.getJ4pServerUrl() + ": " + pException.getMessage(), (ConnectException)pException);
        }
        if (pException instanceof ConnectTimeoutException) {
            return new J4pTimeoutException("Read timeout while request " + this.requestHandler.getJ4pServerUrl() + ": " + pException.getMessage(), (ConnectTimeoutException)pException);
        }
        if (pException instanceof IOException) {
            return new J4pException("IO-Error while contacting the server: " + pException, pException);
        }
        if (pException instanceof URISyntaxException) {
            URISyntaxException sExp = (URISyntaxException)pException;
            return new J4pException("Invalid URI " + sExp.getInput() + ": " + sExp.getReason(), pException);
        }
        return new J4pException("Exception " + pException, pException);
    }

    private void verifyBulkJsonResponse(JSONAware pJsonResponse) throws J4pException {
        if (!(pJsonResponse instanceof JSONArray)) {
            JSONObject errorObject;
            J4pRemoteException exp;
            if (pJsonResponse instanceof JSONObject && (exp = this.validate(null, errorObject = (JSONObject)pJsonResponse)) != null) {
                throw exp;
            }
            throw new J4pException("Invalid JSON answer for a bulk request (expected an array but got a " + pJsonResponse.getClass() + ")");
        }
    }

    private <T extends J4pRequest> J4pRemoteException validate(T pRequest, JSONObject pJsonRespObject) {
        Long status = (Long)pJsonRespObject.get((Object)"status");
        if (status == null) {
            return new J4pRemoteException(pRequest, "Invalid response received: " + pJsonRespObject.toJSONString(), null, 500, null);
        }
        if (status != 200L) {
            return new J4pRemoteException(pRequest, (String)pJsonRespObject.get((Object)"error"), (String)pJsonRespObject.get((Object)"error_type"), status.intValue(), (String)pJsonRespObject.get((Object)"stacktrace"));
        }
        return null;
    }

    public <R extends J4pResponse<T>, T extends J4pRequest> List<R> execute(T ... pRequests) throws J4pException {
        return this.execute(Arrays.asList(pRequests));
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

