/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.httpclient5;

import java.io.FileInputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.VersionInfo;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.httpclient5.Http5Client;
import org.jolokia.client.spi.HttpClientBuilder;
import org.jolokia.client.spi.HttpClientSpi;

public class Http5ClientBuilder
implements HttpClientBuilder<HttpClient> {
    public HttpClientSpi<HttpClient> buildHttpClient(JolokiaClientBuilder.Configuration jcb) {
        String user = jcb.user();
        String password = jcb.password();
        JolokiaClientBuilder.Proxy httpProxy = jcb.proxy();
        URI jolokiaAgentUrl = jcb.url();
        org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder = HttpClients.custom().setUserAgent("Jolokia JMX-Client (using Apache-HttpClient/" + Http5ClientBuilder.getVersionInfo() + ")").setConnectionManager(this.createConnectionManager(jcb)).setDefaultCookieStore((CookieStore)new BasicCookieStore()).setDefaultRequestConfig(this.createRequestConfig(jcb));
        Collection defaultHttpHeaders = jcb.defaultHttpHeaders();
        if (defaultHttpHeaders != null && !defaultHttpHeaders.isEmpty()) {
            List<BasicHeader> headers = defaultHttpHeaders.stream().map(h -> new BasicHeader(h.name(), (Object)h.value())).toList();
            builder.setDefaultHeaders(headers);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        boolean credentialsProvided = false;
        if (user != null && !user.isEmpty()) {
            AuthScope targetScope = new AuthScope(jolokiaAgentUrl.getHost(), jolokiaAgentUrl.getPort());
            credentialsProvider.setCredentials(targetScope, (Credentials)new UsernamePasswordCredentials(user, password.toCharArray()));
            credentialsProvided = true;
        }
        if (jcb.user() != null && !jcb.user().isEmpty()) {
            builder.addRequestInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthRequestInterceptor(jcb));
        }
        if (httpProxy != null) {
            HttpHost proxy = new HttpHost(httpProxy.getHost(), httpProxy.getPort());
            builder.setProxy(proxy);
            if (httpProxy.getUser() != null) {
                AuthScope proxyScope = new AuthScope(httpProxy.getHost(), httpProxy.getPort());
                credentialsProvider.setCredentials(proxyScope, (Credentials)new UsernamePasswordCredentials(httpProxy.getUser(), httpProxy.getPass().toCharArray()));
                credentialsProvided = true;
            }
        }
        if (credentialsProvided) {
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if (jcb.customizer() != null) {
            Class builderClass = jcb.clientBuilderClass();
            if (!builderClass.isAssignableFrom(builder.getClass())) {
                throw new IllegalArgumentException("Unsupported class for HttpClient5 builder associated with the customizer: " + builderClass.getName());
            }
            jcb.customizer().accept(builder);
        }
        return new Http5Client(builder.build(), jcb, credentialsProvider);
    }

    private static String getVersionInfo() {
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.hc.client5", (ClassLoader)Http5ClientBuilder.class.getClassLoader());
        return vi != null ? vi.getRelease() : "UNAVAILABLE";
    }

    private HttpClientConnectionManager createConnectionManager(JolokiaClientBuilder.Configuration jcb) {
        BasicHttpClientConnectionManager manager;
        ConnectionConfig.Builder ccBuilder = ConnectionConfig.custom();
        JolokiaClientBuilder.ConnectionConfiguration jcbConnectionConfig = jcb.connectionConfig();
        if (jcbConnectionConfig.connectionTimeout() != -1) {
            ccBuilder.setConnectTimeout((long)jcbConnectionConfig.connectionTimeout(), TimeUnit.MILLISECONDS);
        }
        if (jcbConnectionConfig.socketTimeout() != -1) {
            ccBuilder.setSocketTimeout(jcbConnectionConfig.socketTimeout(), TimeUnit.MILLISECONDS);
        }
        ConnectionConfig connectionConfig = ccBuilder.build();
        SocketConfig.Builder scBuilder = SocketConfig.custom();
        scBuilder.setRcvBufSize(jcbConnectionConfig.socketBufferSize());
        scBuilder.setSndBufSize(jcbConnectionConfig.socketBufferSize());
        if (jcbConnectionConfig.socketTimeout() != -1) {
            scBuilder.setSoTimeout(jcbConnectionConfig.socketTimeout(), TimeUnit.MILLISECONDS);
        }
        scBuilder.setTcpNoDelay(jcbConnectionConfig.tcpNoDelay());
        SocketConfig socketConfig = scBuilder.build();
        TlsConfig tlsConfig = null;
        DefaultClientTlsStrategy tlsStrategy = null;
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (jcb.tlsConfig() != null && jcb.tlsConfig().protocolVersion() != null) {
            TlsConfig.Builder tcBuilder = TlsConfig.custom();
            tcBuilder.setSupportedProtocols(new String[]{jcb.tlsConfig().protocolVersion()});
            tlsConfig = tcBuilder.build();
            try {
                SSLContext sslContext = this.createSSLSocketFactory(jcb);
                tlsStrategy = new DefaultClientTlsStrategy(sslContext);
                registryBuilder.register("https", (Object)tlsStrategy);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Problem with TLS configuration: " + e.getMessage(), e);
            }
        }
        Registry registry = registryBuilder.build();
        if (jcb.poolConfig().usePool()) {
            manager = PoolingHttpClientConnectionManagerBuilder.create().setSchemePortResolver((SchemePortResolver)DefaultSchemePortResolver.INSTANCE).setDnsResolver((DnsResolver)SystemDefaultDnsResolver.INSTANCE).setConnectionFactory((HttpConnectionFactory)ManagedHttpClientConnectionFactory.INSTANCE).setDefaultConnectionConfig(connectionConfig).setDefaultSocketConfig(socketConfig).setMaxConnTotal(jcb.poolConfig().maxConnections()).setMaxConnPerRoute(jcb.poolConfig().maxConnections()).setTlsSocketStrategy(tlsStrategy).setDefaultTlsConfig(tlsConfig).build();
        } else {
            BasicHttpClientConnectionManager basicManager = BasicHttpClientConnectionManager.create((SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE, (Lookup)registry, (HttpConnectionFactory)ManagedHttpClientConnectionFactory.INSTANCE);
            basicManager.setConnectionConfig(connectionConfig);
            basicManager.setSocketConfig(socketConfig);
            basicManager.setTlsConfig(tlsConfig);
            manager = basicManager;
        }
        return manager;
    }

    private RequestConfig createRequestConfig(JolokiaClientBuilder.Configuration jcb) {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setExpectContinueEnabled(jcb.expectContinue());
        if (jcb.connectionConfig().socketTimeout() > -1) {
            builder.setResponseTimeout((long)jcb.connectionConfig().socketTimeout(), TimeUnit.MILLISECONDS);
        }
        if (jcb.poolConfig().usePool() && jcb.poolConfig().connectionPoolTimeout() > -1) {
            builder.setConnectionRequestTimeout((long)jcb.poolConfig().connectionPoolTimeout(), TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }

    private SSLContext createSSLSocketFactory(JolokiaClientBuilder.Configuration jcb) throws Exception {
        JolokiaClientBuilder.TlsConfiguration tlsConfiguration = jcb.tlsConfig();
        KeyStore ks = null;
        if (tlsConfiguration.keystore() != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(tlsConfiguration.keystore().toFile());){
                ks.load(fis, tlsConfiguration.keystorePassword() == null ? new char[]{} : tlsConfiguration.keystorePassword().toCharArray());
            }
        }
        KeyStore ts = null;
        if (tlsConfiguration.truststore() != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ts = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(tlsConfiguration.truststore().toFile());){
                ts.load(fis, tlsConfiguration.truststorePassword() == null ? new char[]{} : tlsConfiguration.truststorePassword().toCharArray());
                tmf.init(ts);
            }
        }
        return SSLContexts.custom().setProtocol(tlsConfiguration.protocolVersion()).loadKeyMaterial(ks, tlsConfiguration.keyPassword() == null ? new char[]{} : tlsConfiguration.keyPassword().toCharArray()).loadTrustMaterial(ts, null).build();
    }

    private static class PreemptiveAuthRequestInterceptor
    implements HttpRequestInterceptor {
        private final String authorization;

        public PreemptiveAuthRequestInterceptor(JolokiaClientBuilder.Configuration jcb) {
            String credentials = jcb.user() + ":" + (jcb.password() == null ? "" : jcb.password());
            this.authorization = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        }

        public void process(HttpRequest request, EntityDetails entity, HttpContext context) {
            request.setHeader("Authorization", (Object)this.authorization);
            context.getAttribute("");
        }
    }
}

