/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.LinkedList;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONArray;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.Converter;

public class ArrayAccessor
implements ObjectAccessor {
    @Override
    public Class<?> getType() {
        throw new UnsupportedOperationException("ArrayAccessor should be used directly");
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pArray, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        int length = pConverter.getCollectionLength(Array.getLength(pArray));
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            return this.extractArrayElement(pConverter, pArray, pPathParts, pJsonify, pathPart);
        }
        return pJsonify ? this.arrayToJSON(pConverter, pArray, pPathParts, length) : pArray;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pArray, String pIndex, Object pValue) throws IllegalAccessException, InvocationTargetException {
        int idx;
        Class<?> clazz = pArray.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Not an array to set a value, but " + String.valueOf(clazz) + ". (index = " + pIndex + ", value = " + String.valueOf(pValue) + ")");
        }
        try {
            idx = Integer.parseInt(pIndex);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing array " + String.valueOf(pArray) + ". (index = " + pIndex + ", value to set = " + String.valueOf(pValue) + ")", exp);
        }
        Class<?> type = clazz.getComponentType();
        Object value = pConverter.convert(type.getName(), pValue);
        Object oldValue = Array.get(pArray, idx);
        Array.set(pArray, idx, value);
        return oldValue;
    }

    private JSONArray arrayToJSON(ObjectToJsonConverter pConverter, Object pArray, Deque<String> pPath, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray(pLength);
        for (int i = 0; i < pLength; ++i) {
            LinkedList<String> path = new LinkedList<String>(pPath);
            try {
                Object obj = Array.get(pArray, i);
                ret.add(pConverter.extractObject(obj, path, true));
                continue;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
                // empty catch block
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractArrayElement(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPath, boolean pJsonify, String pPathPart) throws AttributeNotFoundException {
        try {
            Object obj = Array.get(pValue, Integer.parseInt(pPathPart));
            return pConverter.extractObject(obj, pPath, pJsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is not a numeric for accessing an array"));
        }
        catch (ArrayIndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException(new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for an array of size " + Array.getLength(pValue)));
        }
    }
}

