/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.api.DataUpdater;
import org.jolokia.server.core.util.JsonUtil;
import org.jolokia.service.jmx.handler.list.DataKeys;

class OperationDataUpdater
extends DataUpdater {
    protected OperationDataUpdater() {
        super(100);
    }

    @Override
    public String getKey() {
        return DataKeys.OPERATIONS.getKey();
    }

    @Override
    public JSONObject extractData(ObjectName pObjectName, MBeanInfo pMBeanInfo, String pOperation) {
        JSONObject opMap = new JSONObject();
        for (MBeanOperationInfo opInfo : pMBeanInfo.getOperations()) {
            if (pOperation != null && !opInfo.getName().equals(pOperation)) continue;
            JSONObject map = new JSONObject();
            JSONArray argList = new JSONArray(opInfo.getSignature().length);
            for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
                JSONObject args = new JSONObject();
                args.put(DataKeys.DESCRIPTION.getKey(), paramInfo.getDescription());
                args.put(DataKeys.NAME.getKey(), paramInfo.getName());
                args.put(DataKeys.TYPE.getKey(), paramInfo.getType());
                argList.add(args);
            }
            map.put(DataKeys.ARGS.getKey(), argList);
            map.put(DataKeys.RETURN_TYPE.getKey(), opInfo.getReturnType());
            map.put(DataKeys.DESCRIPTION.getKey(), opInfo.getDescription());
            JsonUtil.addJSONObjectToJSONObject(opMap, opInfo.getName(), map);
        }
        return opMap;
    }
}

