/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.Converter;

public class MapAccessor
implements ObjectAccessor {
    private static final int MAX_STRING_LENGTH = 400;

    @Override
    public Class<?> getType() {
        return Map.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pMap, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        Map<String, Object> map = (Map<String, Object>)pMap;
        int length = pConverter.getCollectionLength(map.size());
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            return this.extractMapValue(pConverter, map, pPathParts, pJsonify, pathPart);
        }
        return pJsonify ? this.mapToJSON(pConverter, map, pPathParts, length) : map;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pMap, String pKey, Object pValue) throws IllegalAccessException, InvocationTargetException {
        if (!(pMap instanceof Map)) {
            throw new IllegalArgumentException("MapAccessor can't access objects of type " + String.valueOf(pMap.getClass()));
        }
        Map map = (Map)pMap;
        Object newKey = pKey;
        Object oldKey = null;
        if (!map.isEmpty()) {
            Object someKey = map.keySet().iterator().next();
            newKey = pConverter.convert(someKey.getClass().getName(), newKey);
        }
        Object oldValue = ((Map)pMap).get(newKey);
        Object newValue = pValue;
        if (oldValue != null) {
            newValue = pConverter.convert(oldValue.getClass().getName(), pValue);
        }
        map.put(newKey, newValue);
        return oldValue;
    }

    private JSONObject mapToJSON(ObjectToJsonConverter pConverter, Map<?, ?> pMap, Deque<String> pPath, int pLength) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        int i = 0;
        for (Map.Entry<?, ?> entry : pMap.entrySet()) {
            LinkedList<String> paths = new LinkedList<String>(pPath);
            try {
                ret.put((String)pConverter.getConverter().convert(String.class.getName(), entry.getKey()), pConverter.extractObject(entry.getValue(), paths, true));
                if (++i < pLength) continue;
                break;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractMapValue(ObjectToJsonConverter pConverter, Map<?, ?> pMap, Deque<String> pPath, boolean pJsonify, String pKey) throws AttributeNotFoundException {
        Object key = pKey;
        if (!pMap.isEmpty()) {
            Object someKey = pMap.keySet().iterator().next();
            key = pConverter.getConverter().convert(someKey.getClass().getName(), key);
        }
        if (pMap.containsKey(key)) {
            return pConverter.extractObject(pMap.get(key), pPath, pJsonify);
        }
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        return faultHandler.handleException(new AttributeNotFoundException("Map key '" + pKey + "' is unknown for map " + this.trimString(pMap.toString())));
    }

    private String trimString(String pString) {
        if (pString.length() > 400) {
            return pString.substring(0, 400) + " ...";
        }
        return pString;
    }
}

