/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.notif.sse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.Notification;
import org.jolokia.server.core.http.BackChannel;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.notification.BackendCallback;
import org.jolokia.server.core.service.notification.Client;
import org.jolokia.server.core.service.notification.NotificationBackend;
import org.jolokia.server.core.service.notification.NotificationResult;
import org.jolokia.server.core.service.notification.NotificationSubscription;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.service.notif.sse.SseHeartBeat;
import org.json.simple.JSONObject;

public class SseNotificationBackend
extends AbstractJolokiaService<NotificationBackend>
implements NotificationBackend {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] ID_FIELD = "id: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATA_FIELD = "data: ".getBytes(StandardCharsets.UTF_8);
    private final HashMap<String, SseHeartBeat> heartBeatMap = new HashMap();

    public SseNotificationBackend(int order) {
        super(NotificationBackend.class, order);
    }

    @Override
    public void init(JolokiaContext pContext) {
        if (this.getJolokiaContext() == null) {
            super.init(pContext);
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.getJolokiaContext() != null) {
            super.destroy();
        }
    }

    @Override
    public String getNotifType() {
        return "sse";
    }

    @Override
    public BackendCallback subscribe(final NotificationSubscription pSubscription) {
        final Client client = pSubscription.getClient();
        return new BackendCallback(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                BackChannel backChannel = client.getBackChannel(SseNotificationBackend.this.getNotifType());
                if (backChannel != null && !backChannel.isClosed()) {
                    JolokiaContext ctx = SseNotificationBackend.this.getJolokiaContext();
                    Serializer serializer = ctx.getMandatoryService(Serializer.class);
                    NotificationResult result = new NotificationResult(pSubscription.getHandle(), Collections.singletonList(notification), handback, 0);
                    try {
                        long id = notification.getSequenceNumber();
                        String data = serializer.serialize(result, null, SerializeOptions.DEFAULT).toString();
                        SseNotificationBackend.this.sendMessage(backChannel, id, data);
                    }
                    catch (IOException iOException) {
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    @Override
    public void channelInit(Client client, BackChannel channel) {
        SseHeartBeat heartBeat = new SseHeartBeat(channel);
        heartBeat.start();
        this.heartBeatMap.put(client.getId(), heartBeat);
    }

    @Override
    public void unsubscribe(String pClientId, String pHandle) {
    }

    @Override
    public void unregister(Client pClient) {
        BackChannel backChannel;
        SseHeartBeat heartBeat = this.heartBeatMap.remove(pClient.getId());
        if (heartBeat != null) {
            heartBeat.stop();
        }
        if ((backChannel = pClient.getBackChannel(this.getNotifType())) != null) {
            backChannel.close();
        }
    }

    @Override
    public Map<String, ?> getConfig() {
        JSONObject ret = new JSONObject();
        ret.put("backChannel.contentType", "text/event-stream");
        ret.put("backChannel.encoding", "UTF-8");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(BackChannel pBackChannel, long pId, String pData) throws IOException {
        BackChannel backChannel = pBackChannel;
        synchronized (backChannel) {
            OutputStream os = pBackChannel.getOutputStream();
            this.id(os, pId);
            this.data(os, pData);
            os.write(CRLF);
            os.flush();
        }
    }

    private void id(OutputStream pOs, long pId) throws IOException {
        this.printLine(pOs, ID_FIELD, Long.toString(pId).getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void data(OutputStream pOs, String pData) throws IOException {
        SseNotificationBackend sseNotificationBackend = this;
        synchronized (sseNotificationBackend) {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(pData));
            while ((line = reader.readLine()) != null) {
                this.printLine(pOs, DATA_FIELD, line.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private void printLine(OutputStream pOs, byte[] pField, byte[] pValue) throws IOException {
        pOs.write(pField);
        pOs.write(pValue);
        pOs.write(CRLF);
    }
}

