/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.IOException;
import java.util.List;
import javax.management.ObjectName;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.service.discovery.AbstractDiscoveryMessage;
import org.jolokia.service.discovery.DiscoveryIncomingMessage;
import org.jolokia.service.discovery.DiscoveryOutgoingMessage;
import org.jolokia.service.discovery.JolokiaDiscoveryMBean;
import org.jolokia.service.discovery.MulticastUtil;
import org.json.simple.JSONArray;

public class JolokiaDiscovery
extends AbstractJolokiaService<JolokiaService.Init>
implements JolokiaDiscoveryMBean,
JolokiaService.Init {
    private ObjectName objectName;

    public JolokiaDiscovery(int pOrder) {
        super(JolokiaService.Init.class, pOrder);
    }

    public JolokiaDiscovery() {
        super(JolokiaService.Init.class, 0);
    }

    @Override
    public void init(JolokiaContext pJolokiaContext) {
        super.init(pJolokiaContext);
        this.objectName = this.registerJolokiaMBean("jolokia:type=Discovery", this);
    }

    @Override
    public void destroy() throws Exception {
        this.unregisterJolokiaMBean(this.objectName);
        super.destroy();
    }

    @Override
    public List lookupAgents() throws IOException {
        return this.lookupAgentsWithTimeout(1000);
    }

    @Override
    public List lookupAgentsWithTimeout(int pTimeout) throws IOException {
        String group = this.getJolokiaContext().getConfig(ConfigKey.MULTICAST_GROUP, true);
        String port = this.getJolokiaContext().getConfig(ConfigKey.MULTICAST_PORT, true);
        return this.lookupAgentsWithTimeoutAndMulticastAddress(1000, group, Integer.parseInt(port));
    }

    @Override
    public List lookupAgentsWithTimeoutAndMulticastAddress(int pTimeout, String pMulticastGroup, int pMulticastPort) throws IOException {
        JolokiaContext ctx = this.getJolokiaContext();
        DiscoveryOutgoingMessage out = new DiscoveryOutgoingMessage.Builder(AbstractDiscoveryMessage.MessageType.QUERY).agentId(ctx.getAgentDetails().getAgentId()).build();
        List<DiscoveryIncomingMessage> discovered = MulticastUtil.sendQueryAndCollectAnswers(out, pTimeout, pMulticastGroup, pMulticastPort, ctx);
        JSONArray ret = new JSONArray();
        for (DiscoveryIncomingMessage in : discovered) {
            ret.add(in.getAgentDetails().toJSONObject());
        }
        return ret;
    }
}

