/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.detector.jee;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.detector.DefaultServerHandle;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.service.api.AbstractJolokiaService;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.service.request.RequestInterceptor;
import org.jolokia.server.core.util.jmx.JmxUtil;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.server.detector.jee.AbstractServerDetector;
import org.json.simple.JSONObject;

public class GlassfishDetector
extends AbstractServerDetector {
    private static final Pattern GLASSFISH_VERSION = Pattern.compile("^.*(?:Glassfish|Payara).*\\sv?(.*?)$", 2);
    private static final Pattern GLASSFISH_FULL_VERSION = Pattern.compile("^.*(?:Glassfish|Payara).*?\\sv?([.\\d]+).*$", 2);
    private static final Pattern PAYARA_VERSION = Pattern.compile("^.*Payara.*\\sv?(.*?)$", 2);
    private static final Pattern PAYARA_FULL_VERSION = Pattern.compile("^.*Payara.*?\\sv?([.\\d]+).*$", 2);
    private static final String GLASSFISH_NAME = "glassfish";
    private static final String GLASSFISH_VENDOR_NAME = "Oracle";
    private static final String PAYARA_NAME = "Payara Server";
    private static final String PAYARA_VENDOR_NAME = "Payara Foundation";
    private String serverName;
    private String vendorName;

    public GlassfishDetector(int pOrder) {
        super(GLASSFISH_NAME, pOrder);
    }

    @Override
    public ServerHandle detect(MBeanServerAccess pMBeanServerAccess) {
        String version = this.detectVersion(pMBeanServerAccess);
        if (version != null) {
            return new GlassfishServerHandle(version);
        }
        return null;
    }

    @Override
    public RequestInterceptor getRequestInterceptor(MBeanServerAccess pMBeanServerAccess) {
        if (this.amxShouldBeBooted(pMBeanServerAccess)) {
            return new AmxBootInterceptor(pMBeanServerAccess);
        }
        return null;
    }

    private String detectVersion(MBeanServerAccess pMBeanServerAccess) {
        String fullVersion = this.getSingleStringAttribute(pMBeanServerAccess, "com.sun.appserv:j2eeType=J2EEServer,*", "serverVersion");
        String version = this.extractVersionFromFullVersion(fullVersion);
        if (fullVersion == null || "3".equals(version)) {
            String versionFromAmx = this.getSingleStringAttribute(pMBeanServerAccess, "amx:type=domain-root,*", "ApplicationServerFullVersion");
            version = this.getVersionFromFullVersion(version, versionFromAmx != null ? versionFromAmx : System.getProperty("glassfish.version"));
        } else if (this.mBeanExists(pMBeanServerAccess, "com.sun.appserver:type=Host,*")) {
            version = "3";
        }
        return version;
    }

    private String extractVersionFromFullVersion(String pFullVersion) {
        if (pFullVersion != null) {
            Matcher matcher = GLASSFISH_VERSION.matcher(pFullVersion);
            if (matcher.matches()) {
                this.serverName = GLASSFISH_NAME;
                this.vendorName = GLASSFISH_VENDOR_NAME;
                return matcher.group(1);
            }
            matcher = PAYARA_VERSION.matcher(pFullVersion);
            if (matcher.matches()) {
                this.serverName = PAYARA_NAME;
                this.vendorName = PAYARA_VENDOR_NAME;
                return matcher.group(1);
            }
        }
        return null;
    }

    private boolean amxShouldBeBooted(MBeanServerAccess pMBeanServerAccess) {
        Boolean bootAmx = (Boolean)this.getConfig("bootAmx");
        return (bootAmx == null || bootAmx != false) && !this.isAmxBooted(pMBeanServerAccess);
    }

    private boolean isAmxBooted(MBeanServerAccess pServerManager) {
        return this.mBeanExists(pServerManager, "amx:type=domain-root,*");
    }

    private String getVersionFromFullVersion(String pOriginalVersion, String pFullVersion) {
        if (pFullVersion == null) {
            return pOriginalVersion;
        }
        Matcher v3Matcher = GLASSFISH_FULL_VERSION.matcher(pFullVersion);
        Matcher payaraMatcher = PAYARA_FULL_VERSION.matcher(pFullVersion);
        if (v3Matcher.matches()) {
            this.serverName = GLASSFISH_NAME;
            this.vendorName = GLASSFISH_VENDOR_NAME;
            return v3Matcher.group(1);
        }
        if (payaraMatcher.matches()) {
            this.serverName = PAYARA_NAME;
            this.vendorName = PAYARA_VENDOR_NAME;
            return payaraMatcher.group(1);
        }
        return pOriginalVersion;
    }

    private class GlassfishServerHandle
    extends DefaultServerHandle {
        public GlassfishServerHandle(String version) {
            super(GlassfishDetector.this.vendorName, GlassfishDetector.this.serverName, version);
        }

        @Override
        public Map<String, String> getExtraInfo(MBeanServerAccess pExecutor) {
            HashMap<String, String> extra = new HashMap<String, String>();
            if (this.getVersion().startsWith("3")) {
                extra.put("amxBooted", Boolean.toString(GlassfishDetector.this.isAmxBooted(pExecutor)));
            }
            return extra;
        }
    }

    private static final class AmxBootInterceptor
    extends AbstractJolokiaService<RequestInterceptor>
    implements RequestInterceptor {
        private final MBeanServerAccess serverAccess;
        private boolean isBooted;
        private JolokiaContext jolokiaContext;

        private AmxBootInterceptor(MBeanServerAccess pServerAccess) {
            super(RequestInterceptor.class, 0);
            this.serverAccess = pServerAccess;
        }

        @Override
        public void intercept(JolokiaRequest pRequest, JSONObject pRetValue) {
            if (!this.isBooted) {
                this.isBooted = this.bootAmx(this.serverAccess);
            }
        }

        @Override
        public void init(JolokiaContext pJolokiaContext) {
            super.init(pJolokiaContext);
            this.jolokiaContext = pJolokiaContext;
        }

        private synchronized boolean bootAmx(MBeanServerAccess pServers) {
            ObjectName bootMBean = JmxUtil.newObjectName("amx-support:type=boot-amx");
            try {
                pServers.call(bootMBean, new MBeanServerAccess.MBeanAction<Void>(){

                    @Override
                    public Void execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException {
                        pConn.invoke(pName, "bootAMX", null, null);
                        return null;
                    }
                }, new Object[0]);
                return true;
            }
            catch (InstanceNotFoundException e) {
                this.jolokiaContext.error("No bootAmx MBean found: " + e, e);
                return false;
            }
            catch (IllegalArgumentException e) {
                this.jolokiaContext.error("Exception while booting AMX: " + e, e);
                return true;
            }
            catch (Exception e) {
                this.jolokiaContext.error("Exception while executing bootAmx: " + e, e);
                return true;
            }
        }
    }
}

