/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.jolokia.jvmagent.security.asn1.DERObject;

public class DERObjectIdentifier
implements DERObject {
    public static final byte DER_OBJECTIDENTIFIER_TAG = 6;
    public static final String OID_countryName = "2.5.4.6";
    public static final String OID_stateOrProvinceName = "2.5.4.8";
    public static final String OID_localityName = "2.5.4.7";
    public static final String OID_organizationName = "2.5.4.10";
    public static final String OID_organizationalUnitName = "2.5.4.11";
    public static final String OID_commonName = "2.5.4.3";
    public static final String OID_rsaEncryption = "1.2.840.113549.1.1.1";
    public static final String OID_sha1WithRSAEncryption = "1.2.840.113549.1.1.5";
    public static final String OID_sha512WithRSAEncryption = "1.2.840.113549.1.1.13";
    public static final String OID_SHA3_512withRSA = "2.16.840.1.101.3.4.3.16";
    public static final String OID_subjectKeyIdentifier = "2.5.29.14";
    public static final String OID_keyUsage = "2.5.29.15";
    public static final String OID_subjectAltName = "2.5.29.17";
    public static final String OID_basicConstraints = "2.5.29.19";
    public static final String OID_authorityKeyIdentifier = "2.5.29.35";
    public static final String OID_extKeyUsage = "2.5.29.37";
    public static final String OID_id_kp_serverAuth = "1.3.6.1.5.5.7.3.1";
    public static final String OID_id_kp_clientAuth = "1.3.6.1.5.5.7.3.2";
    public static final String OID_id_kp_codeSigning = "1.3.6.1.5.5.7.3.3";
    public static final String OID_id_kp_emailProtection = "1.3.6.1.5.5.7.3.4";
    private final int[] values;
    private final String value;

    public DERObjectIdentifier(String value) {
        this.value = value;
        String[] vt = value.split("\\.");
        this.values = new int[vt.length];
        int p = 0;
        for (String v : vt) {
            try {
                if (v.trim().isEmpty()) {
                    throw new IllegalArgumentException("Bad syntax for OID \"" + value + "\"");
                }
                this.values[p] = Integer.parseInt(v);
                if (this.values[p] < 0) {
                    throw new IllegalArgumentException("Subidentifiers of OID should be greater than 0");
                }
                if (p == 0 && this.values[p] > 2) {
                    throw new IllegalArgumentException("First subidentifier of OID should be 0, 1 or 2");
                }
                ++p;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad syntax for OID \"" + value + "\"");
            }
        }
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(6);
        baos.write(0);
        try {
            baos.write(this.encodeSubIdentifier(this.values[0] * 40 + (this.values.length > 1 ? this.values[1] : 0)));
            for (int i = 2; i < this.values.length; ++i) {
                baos.write(this.encodeSubIdentifier(this.values[i]));
            }
        }
        catch (IOException i) {
            // empty catch block
        }
        byte[] result = baos.toByteArray();
        result[1] = (byte)(result.length - 2);
        return result;
    }

    private byte[] encodeSubIdentifier(int value) {
        int start;
        byte[] maxResult = new byte[5];
        int v = value;
        for (int i = 4; i >= 0; --i) {
            maxResult[i] = (byte)(v & 0x7F);
            if (i < 4) {
                int n = i;
                maxResult[n] = (byte)(maxResult[n] | 0xFFFFFF80);
            }
            v >>>= 7;
        }
        for (start = 0; start < 4 && (maxResult[start] & 0x7F) == 0; ++start) {
        }
        if (start == 0) {
            return maxResult;
        }
        byte[] result = new byte[5 - start];
        System.arraycopy(maxResult, start, result, 0, 5 - start);
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public int[] getValues() {
        return this.values;
    }

    public String asOid() {
        return this.value;
    }

    public static DERObject parse(byte[] encoded, int length, int offset) {
        if (length > 127) {
            throw new IllegalArgumentException("Can't decode ObjectIdentifier with content octets exceeding 127 bytes");
        }
        int v = encoded[offset] & 0xFF;
        if (length == 1 && (v & 0x80) == 0) {
            int v1 = v < 120 ? v / 40 : 2;
            int v2 = v - v1 * 40;
            return new DERObjectIdentifier(String.format("%d.%d", v1, v2));
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        int current = 0;
        for (int pos = offset; pos < offset + length; ++pos) {
            v = encoded[pos] & 0xFF;
            current <<= 7;
            current |= v & 0x7F;
            if ((v & 0x80) != 0) continue;
            if (!values.isEmpty()) {
                values.add(current);
            } else {
                int v1 = current < 120 ? current / 40 : 2;
                int v2 = current - v1 * 40;
                values.add(v1);
                values.add(v2);
            }
            current = 0;
        }
        return new DERObjectIdentifier(values.stream().map(i -> Integer.toString(i)).collect(Collectors.joining(".")));
    }
}

