/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security.asn1;

import java.math.BigInteger;
import org.jolokia.jvmagent.security.asn1.DERObject;
import org.jolokia.jvmagent.security.asn1.DERUtils;

public class DERInteger
implements DERObject {
    private static final byte DER_INTEGER_TAG = 2;
    private final int value;
    private final BigInteger bigValue;

    public DERInteger(int value) {
        this.value = value;
        this.bigValue = null;
    }

    public DERInteger(BigInteger value) {
        this.bigValue = value;
        this.value = 0;
    }

    @Override
    public byte[] getEncoded() {
        if (this.bigValue != null) {
            byte[] number = this.bigValue.toByteArray();
            byte[] length = DERUtils.encodeLength(number.length);
            byte[] result = new byte[1 + length.length + number.length];
            result[0] = 2;
            System.arraycopy(length, 0, result, 1, length.length);
            System.arraycopy(number, 0, result, 1 + length.length, number.length);
            return result;
        }
        int v = this.value;
        if (this.value < 0) {
            v = -this.value - 1 & Integer.MAX_VALUE;
        }
        if (v < 128) {
            byte[] byArray;
            if (this.value < 0) {
                byte[] byArray2 = new byte[3];
                byArray2[0] = 2;
                byArray2[1] = 1;
                byArray = byArray2;
                byArray2[2] = (byte)(127 - v | 0x80);
            } else {
                byte[] byArray3 = new byte[3];
                byArray3[0] = 2;
                byArray3[1] = 1;
                byArray = byArray3;
                byArray3[2] = (byte)v;
            }
            return byArray;
        }
        if (v < 32768) {
            if (this.value < 0) {
                v = Short.MAX_VALUE - v;
                return new byte[]{2, 2, (byte)((v & 0x7F00) >> 8 | 0x80), (byte)(v & 0xFF)};
            }
            return new byte[]{2, 2, (byte)((v & 0x7F00) >> 8), (byte)(v & 0xFF)};
        }
        if (v < 0x800000) {
            if (this.value < 0) {
                v = 0x7FFFFF - v;
                return new byte[]{2, 3, (byte)((v & 0x7F0000) >> 16 | 0x80), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
            }
            return new byte[]{2, 3, (byte)((v & 0x7F0000) >> 16), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
        }
        if (this.value < 0) {
            v = Integer.MAX_VALUE - v;
            return new byte[]{2, 4, (byte)((v & 0x7F000000) >> 24 | 0x80), (byte)((v & 0xFF0000) >> 16), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
        }
        return new byte[]{2, 4, (byte)((v & 0x7F000000) >> 24), (byte)((v & 0xFF0000) >> 16), (byte)((v & 0xFF00) >> 8), (byte)(v & 0xFF)};
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public int asInt() {
        return this.bigValue != null ? this.bigValue.intValue() : this.value;
    }

    public BigInteger asBigInteger() {
        return this.bigValue != null ? this.bigValue : BigInteger.valueOf(this.value);
    }

    public static DERInteger parse(byte[] encoded, int length, int offset) {
        BigInteger big = new BigInteger(encoded, offset, length);
        return new DERInteger(big);
    }
}

