/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import org.jolokia.jvmagent.JolokiaServer;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.jvmagent.JvmAgentConfig;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.detector.ServerDetectorLookup;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.impl.CachingServerDetectorLookup;
import org.jolokia.server.core.service.impl.ClasspathServerDetectorLookup;
import org.jolokia.server.core.service.impl.StdoutLogHandler;

public final class JvmAgent {
    private static JolokiaServer server;
    private static Instrumentation instrumentation;
    private static JvmAgentConfig config;
    private static boolean lazy;
    private static JolokiaWatcher jolokiaWatchThread;
    private static final Map<String, Long> crcs;
    public static final String JOLOKIA_AGENT_URL = "jolokia.agent";
    private static String version;
    private static long pid;

    private JvmAgent() {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        JvmAgentConfig config = new JvmAgentConfig(agentArgs);
        JvmAgent.startAgent(config, config.isLazy(), inst);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        JvmAgentConfig config = new JvmAgentConfig(agentArgs);
        if (!config.isModeStop()) {
            JvmAgent.startAgent(config, config.isLazy(), instrumentation);
        } else {
            JvmAgent.stopAgent(true);
        }
    }

    private static void startAgent(final JvmAgentConfig pConfig, final boolean pLazy, final Instrumentation instrumentation) {
        JvmAgent.instrumentation = instrumentation;
        config = pConfig;
        lazy = pLazy;
        try (InputStream is = JvmAgent.class.getResourceAsStream("/jolokia-agent-version.properties");){
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
            }
            version = props.getProperty("version");
        }
        catch (IOException ignored) {
            version = null;
        }
        try {
            pid = ProcessHandle.current().pid();
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        Thread jolokiaStartThread = new Thread("JolokiaStart"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CachingServerDetectorLookup lookup = new CachingServerDetectorLookup((ServerDetectorLookup)new ClasspathServerDetectorLookup());
                    ClassLoader loader = JvmAgent.awaitServerInitialization(instrumentation, (ServerDetectorLookup)lookup);
                    pConfig.setClassLoader(loader);
                    server = new JolokiaServer((JolokiaServerConfig)pConfig, (ServerDetectorLookup)lookup);
                    1 var3_4 = this;
                    synchronized (var3_4) {
                        server.start(pLazy);
                        JvmAgent.setStateMarker();
                        JvmAgent.configureWatcher(server, pConfig);
                    }
                    Object v = version == null ? "" : " " + version;
                    Object processId = pid == 0L ? "" : " and PID " + pid;
                    System.out.println("Jolokia: Agent" + (String)v + " started with URL " + server.getUrl() + (String)processId);
                }
                catch (IOException | RuntimeException exp) {
                    System.err.println("Could not start Jolokia agent: " + String.valueOf(exp));
                }
            }
        };
        jolokiaStartThread.setDaemon(true);
        System.getLogger("org.jolokia.agent");
        jolokiaStartThread.start();
    }

    private static ClassLoader awaitServerInitialization(Instrumentation instrumentation, ServerDetectorLookup lookup) {
        SortedSet detectors = lookup.lookup((LogHandler)new StdoutLogHandler());
        ServerDetector activeDetector = null;
        ClassLoader highOrderClassLoader = null;
        for (ServerDetector detector : detectors) {
            ClassLoader cl = detector.jvmAgentStartup(instrumentation);
            if (cl == null) continue;
            if (highOrderClassLoader != null) {
                System.err.printf("Invalid ServerDetector configuration. Detector \"%s\" already provided a classloader and different detector (\"%s\") overrides it.", activeDetector.getName(), detector.getName());
                throw new RuntimeException("Invalid ServerDetector configuration");
            }
            highOrderClassLoader = cl;
            activeDetector = detector;
        }
        return highOrderClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void stopAgent(boolean waitForWatcher) {
        try {
            if (server == null) return;
            Class<JvmAgent> clazz = JvmAgent.class;
            synchronized (JvmAgent.class) {
                server.stop();
                JvmAgent.clearStateMarker();
                JvmAgent.stopWatcher(waitForWatcher);
                server = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (RuntimeException exp) {
            System.err.println("Could not stop Jolokia agent: " + String.valueOf(exp));
            exp.printStackTrace();
        }
    }

    private static void setStateMarker() {
        String url = server.getUrl();
        System.setProperty(JOLOKIA_AGENT_URL, url);
    }

    private static void clearStateMarker() {
        System.clearProperty(JOLOKIA_AGENT_URL);
        System.out.println("Jolokia: Agent stopped");
    }

    private static void configureWatcher(JolokiaServer server, JvmAgentConfig pConfig) {
        if (pConfig.useHttps() && pConfig.useCertificateReload() > 0) {
            try {
                List<File> files = server.getWatchedFiles();
                crcs.clear();
                for (File file : files) {
                    crcs.put(file.getCanonicalPath(), JvmAgent.calculateCrc(file.getPath()));
                }
                JolokiaWatcher jolokiaWatchThread = new JolokiaWatcher(crcs, pConfig.useCertificateReload());
                jolokiaWatchThread.setDaemon(true);
                jolokiaWatchThread.start();
                System.out.println("Jolokia: Registered watcher for certificate changes (poller: " + pConfig.useCertificateReload() + "s, files: " + files.stream().map(File::getName).collect(Collectors.joining(", ")) + ")");
                JvmAgent.jolokiaWatchThread = jolokiaWatchThread;
            }
            catch (IOException e) {
                System.err.println("Jolokia: FileSystem watch service unavailable: " + e.getMessage());
            }
        }
    }

    private static long calculateCrc(String file) {
        long l;
        FileInputStream fis = new FileInputStream(file);
        try {
            int read;
            byte[] buffer = new byte[8192];
            CRC32 crc = new CRC32();
            while ((read = fis.read(buffer)) > 0) {
                crc.update(buffer, 0, read);
            }
            l = crc.getValue();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        fis.close();
        return l;
    }

    private static void stopWatcher(boolean waitForWatcher) {
        if (jolokiaWatchThread != null) {
            jolokiaWatchThread.setRunning(false);
            if (waitForWatcher) {
                try {
                    jolokiaWatchThread.join();
                    System.out.println("Jolokia: Stopped certificate watcher");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            jolokiaWatchThread = null;
            server.clearWatchedFiles();
        }
    }

    static {
        crcs = new HashMap<String, Long>();
        version = null;
        pid = 0L;
    }

    private static class JolokiaWatcher
    extends Thread {
        private final Map<String, Long> crcs;
        private final int interval;
        private volatile boolean running = true;

        public JolokiaWatcher(Map<String, Long> crcs, int interval) {
            super("JolokiaCertificateWatcher");
            this.crcs = crcs;
            this.interval = interval;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Thread.sleep(this.interval);
                    boolean change = false;
                    ArrayList<String> files = new ArrayList<String>(this.crcs.keySet());
                    for (String f : files) {
                        if (JvmAgent.calculateCrc(f) == this.crcs.get(f)) continue;
                        change = true;
                        break;
                    }
                    if (!change) continue;
                    Thread.sleep(this.interval);
                    System.out.println("Jolokia: Certificate(s) updated, restarting Jolokia agent");
                    JvmAgent.stopAgent(false);
                    JvmAgent.startAgent(config, lazy, instrumentation);
                }
                catch (InterruptedException e) {
                    System.out.println("Jolokia: JolokiaCertificateWatcher stopped");
                }
            }
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }
}

