/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpExchange;
import java.util.ArrayList;
import java.util.List;

public class MultiAuthenticator
extends Authenticator {
    private final ArrayList<Authenticator> authenticators;
    private final Mode mode;

    public MultiAuthenticator(Mode mode, List<Authenticator> authenticators) {
        if (authenticators == null) {
            throw new IllegalArgumentException("Authenticators cannot be null");
        }
        if (authenticators.isEmpty()) {
            throw new IllegalArgumentException("Authenticators cannot be empty");
        }
        this.authenticators = new ArrayList<Authenticator>(authenticators);
        this.mode = mode;
    }

    @Override
    public Authenticator.Result authenticate(HttpExchange httpExchange) {
        Authenticator.Result result = null;
        for (Authenticator a : this.authenticators) {
            result = a.authenticate(httpExchange);
            if ((!(result instanceof Authenticator.Success) || this.mode != Mode.ANY) && (result instanceof Authenticator.Success || this.mode != Mode.ALL)) continue;
            return result;
        }
        return result;
    }

    public static enum Mode {
        ALL,
        ANY;


        public static Mode fromString(String inStr) {
            if (inStr == null || inStr.isEmpty()) {
                return ANY;
            }
            if (inStr.equalsIgnoreCase("any")) {
                return ANY;
            }
            if (inStr.equalsIgnoreCase("all")) {
                return ALL;
            }
            throw new IllegalArgumentException(String.format("Unknown multi authenticator mode %s. Must be either 'any' or 'all'", inStr));
        }
    }
}

