/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.command;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.jolokia.jvmagent.client.command.AbstractBaseCommand;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;
import org.jolokia.server.core.util.JolokiaCipher;

public class EncryptCommand
extends AbstractBaseCommand {
    private final JolokiaCipher.KeyHolder keyHolder;

    public EncryptCommand() {
        this(null);
    }

    public EncryptCommand(JolokiaCipher.KeyHolder pKeyHolder) {
        this.keyHolder = pKeyHolder;
    }

    @Override
    String getName() {
        return "encrypt";
    }

    @Override
    int execute(OptionsAndArgs pOpts, Object pVm, VirtualMachineHandlerOperations pHandler) throws InvocationTargetException {
        try {
            List<String> args = pOpts.getExtraArgs();
            String password = args.isEmpty() ? this.getPasswordFromConsoleOrStdin(pOpts) : args.get(0);
            JolokiaCipher jolokiaCipher = this.keyHolder != null ? new JolokiaCipher(this.keyHolder) : new JolokiaCipher();
            String encrypted = jolokiaCipher.encrypt(password);
            System.out.printf("[[%s]]%n", encrypted);
            return 0;
        }
        catch (GeneralSecurityException exp) {
            throw new InvocationTargetException(exp, "Can not encrypt password");
        }
    }

    private String getPasswordFromConsoleOrStdin(OptionsAndArgs pOpts) {
        Console console = System.console();
        if (console != null) {
            char[] password = console.readPassword(pOpts.isQuiet() ? "" : "Enter password : ", new Object[0]);
            return new String(password);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read password from standard input: " + String.valueOf(e));
        }
    }
}

