/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.VirtualMachineHandler;

public abstract class AbstractBaseCommand {
    abstract String getName();

    abstract int execute(OptionsAndArgs var1, Object var2, VirtualMachineHandler var3) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException;

    protected void loadAgent(Object pVm, OptionsAndArgs pOpts, String ... pAdditionalOpts) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = pVm.getClass();
        Method method = clazz.getMethod("loadAgent", String.class, String.class);
        String args = pOpts.toAgentArg();
        if (pAdditionalOpts.length > 0) {
            args = args.length() != 0 ? args + "," + pAdditionalOpts[0] : pAdditionalOpts[0];
        }
        method.invoke(pVm, pOpts.getJarFilePath(), args.length() > 0 ? args : null);
    }

    protected String checkAgentUrl(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Properties systemProperties = this.getAgentSystemProperties(pVm);
        return systemProperties.getProperty("jolokia.agent");
    }

    protected Properties getAgentSystemProperties(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = pVm.getClass();
        Method method = clazz.getMethod("getSystemProperties", new Class[0]);
        return (Properties)method.invoke(pVm, new Object[0]);
    }

    protected String getProcessDescription(OptionsAndArgs pOpts, VirtualMachineHandler pHandler) {
        if (pOpts.getPid() != null) {
            return "PID " + pOpts.getPid();
        }
        if (pOpts.getProcessPattern() != null) {
            StringBuffer desc = new StringBuffer("process matching \"").append(pOpts.getProcessPattern().pattern()).append("\"");
            try {
                desc.append(" (PID: ").append(pHandler.findProcess(pOpts.getProcessPattern()).getId()).append(")");
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            return desc.toString();
        }
        return "(null)";
    }
}

