/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class JolokiaHttpsConfigurator
extends HttpsConfigurator {
    private boolean useClientAuthentication;

    JolokiaHttpsConfigurator(SSLContext pSSLContext, boolean pUseClientAuthenication) {
        super(pSSLContext);
        this.useClientAuthentication = pUseClientAuthenication;
    }

    @Override
    public void configure(HttpsParameters params) {
        try {
            SSLContext context = SSLContext.getDefault();
            SSLEngine engine = context.createSSLEngine();
            params.setNeedClientAuth(this.useClientAuthentication);
            params.setCipherSuites(engine.getEnabledCipherSuites());
            params.setProtocols(engine.getEnabledProtocols());
            SSLParameters defaultSSLParameters = context.getDefaultSSLParameters();
            defaultSSLParameters.setNeedClientAuth(this.useClientAuthentication);
            params.setSSLParameters(defaultSSLParameters);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("jolokia: Exception while configuring SSL context: " + e, e);
        }
    }
}

