/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.weld;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.jboss.weld.environment.jetty.JettyLegacyContainer;
import org.jboss.weld.environment.servlet.Container;
import org.jboss.weld.environment.servlet.EnhancedListener;
import org.jboss.weld.environment.tomcat.TomcatContainer;
import org.jboss.weld.environment.undertow.UndertowContainer;
import org.joinfaces.autoconfigure.servlet.initializer.ServletContainerInitializerRegistrationBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class WeldServletContainerInitializerRegistrationBean
extends ServletContainerInitializerRegistrationBean<EnhancedListener> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeldServletContainerInitializerRegistrationBean.class);

    public WeldServletContainerInitializerRegistrationBean() {
        super(EnhancedListener.class);
    }

    @Override
    public void customize(ConfigurableServletWebServerFactory factory) {
        this.setContainerClass(factory);
        super.customize(factory);
    }

    void setContainerClass(ConfigurableServletWebServerFactory factory) {
        Class<? extends Container> containerClass = this.findContainerClass(factory);
        if (containerClass != null) {
            String containerClassName = containerClass.getName();
            factory.addInitializers(new ServletContextInitializer[]{servletContext -> {
                String currentContainerClass = servletContext.getInitParameter("org.jboss.weld.environment.container.class");
                if (StringUtils.hasText((String)currentContainerClass)) {
                    log.info("{} has already been set to {}", (Object)"org.jboss.weld.environment.container.class", (Object)currentContainerClass);
                } else {
                    log.debug("Setting {} to {}", (Object)"org.jboss.weld.environment.container.class", (Object)containerClassName);
                    servletContext.setInitParameter("org.jboss.weld.environment.container.class", containerClassName);
                }
            }});
        }
    }

    @Nullable
    Class<? extends Container> findContainerClass(ConfigurableServletWebServerFactory factory) {
        if (factory instanceof TomcatServletWebServerFactory) {
            return TomcatContainer.class;
        }
        if (factory instanceof JettyServletWebServerFactory) {
            return JettyLegacyContainer.class;
        }
        if (factory instanceof UndertowServletWebServerFactory) {
            return UndertowContainer.class;
        }
        return null;
    }
}

