/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.scopemapping;

import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.NoneScoped;
import javax.faces.bean.RequestScoped;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import org.joinfaces.autoconfigure.scopemapping.CustomScopeAnnotationConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RequestScoped.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class JsfScopeAnnotationsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"joinfaces.scope-configurer.jsf.enabled"}, havingValue="true", matchIfMissing=true)
    public static CustomScopeAnnotationConfigurer jsfScopeAnnotationsConfigurer(Environment environment) {
        CustomScopeAnnotationConfigurer scopeAnnotationConfigurer = new CustomScopeAnnotationConfigurer();
        scopeAnnotationConfigurer.setOrder((Integer)environment.getProperty("joinfaces.scope-configurer.jsf.order", Integer.class, (Object)Integer.MAX_VALUE));
        scopeAnnotationConfigurer.addMapping(NoneScoped.class, "prototype");
        scopeAnnotationConfigurer.addMapping(RequestScoped.class, "request");
        scopeAnnotationConfigurer.addMapping(ViewScoped.class, "view");
        scopeAnnotationConfigurer.addMapping(SessionScoped.class, "session");
        scopeAnnotationConfigurer.addMapping(ApplicationScoped.class, "application");
        try {
            Class<?> cdiViewScopedClass = Class.forName("javax.faces.view.ViewScoped");
            scopeAnnotationConfigurer.addMapping(cdiViewScopedClass, "view");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return scopeAnnotationConfigurer;
    }
}

