/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.javaxfaces;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.faces.annotation.ApplicationMap;
import javax.faces.annotation.FlowMap;
import javax.faces.annotation.HeaderMap;
import javax.faces.annotation.HeaderValuesMap;
import javax.faces.annotation.InitParameterMap;
import javax.faces.annotation.RequestCookieMap;
import javax.faces.annotation.RequestMap;
import javax.faces.annotation.RequestParameterMap;
import javax.faces.annotation.RequestParameterValuesMap;
import javax.faces.annotation.SessionMap;
import javax.faces.annotation.ViewMap;
import org.joinfaces.autoconfigure.javaxfaces.JsfBeansAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class JsfBeansAnnotationPostProcessor
implements BeanPostProcessor {
    private final Set<Class<? extends Annotation>> autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private final Map<Class<? extends Annotation>, Supplier<?>> suppliers = new HashMap();

    public JsfBeansAnnotationPostProcessor(JsfBeansAutoConfiguration jsfBeansAutoConfiguration) {
        this.autowiredAnnotationTypes.add(Autowired.class);
        this.autowiredAnnotationTypes.add(Value.class);
        try {
            this.autowiredAnnotationTypes.add(ClassUtils.forName((String)"javax.inject.Inject", (ClassLoader)JsfBeansAnnotationPostProcessor.class.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        this.suppliers.put(ApplicationMap.class, jsfBeansAutoConfiguration::applicationMap);
        this.suppliers.put(FlowMap.class, jsfBeansAutoConfiguration::flowScope);
        this.suppliers.put(HeaderMap.class, jsfBeansAutoConfiguration::headerMap);
        this.suppliers.put(HeaderValuesMap.class, jsfBeansAutoConfiguration::headerValuesMap);
        this.suppliers.put(InitParameterMap.class, jsfBeansAutoConfiguration::initParameterMap);
        this.suppliers.put(RequestCookieMap.class, jsfBeansAutoConfiguration::requestCookieMap);
        this.suppliers.put(RequestMap.class, jsfBeansAutoConfiguration::requestMap);
        this.suppliers.put(RequestParameterMap.class, jsfBeansAutoConfiguration::requestParameterMap);
        this.suppliers.put(RequestParameterValuesMap.class, jsfBeansAutoConfiguration::requestParameterValuesMap);
        this.suppliers.put(SessionMap.class, jsfBeansAutoConfiguration::sessionMap);
        this.suppliers.put(ViewMap.class, jsfBeansAutoConfiguration::viewMap);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), field -> this.suppliers.forEach((annotation, supplier) -> {
            if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, (Class)annotation)) {
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, supplier.get());
            }
        }), this::isAutowiredField);
        return bean;
    }

    boolean isAutowiredField(Field field) {
        for (Class<? extends Annotation> autowiredAnnotationType : this.autowiredAnnotationTypes) {
            if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, autowiredAnnotationType)) continue;
            return true;
        }
        return false;
    }
}

