/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.joinfaces.autoconfigure.rewrite.ApplicationContextProvider;
import org.joinfaces.autoconfigure.rewrite.RewriteProperties;
import org.joinfaces.autoconfigure.servlet.WebFragmentRegistrationBean;
import org.ocpsoft.rewrite.servlet.RewriteFilter;
import org.ocpsoft.rewrite.servlet.impl.RewriteServletContextListener;
import org.ocpsoft.rewrite.servlet.impl.RewriteServletRequestListener;
import org.ocpsoft.rewrite.spring.SpringExpressionLanguageProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@EnableConfigurationProperties(value={RewriteProperties.class})
@ConditionalOnClass(value={RewriteFilter.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class RewriteAutoConfiguration {
    @Bean
    @DependsOn(value={"applicationContextProvider"})
    public WebFragmentRegistrationBean rewriteWebFragmentRegistrationBean() {
        WebFragmentRegistrationBean bean = new WebFragmentRegistrationBean(){

            @Override
            public void customize(ConfigurableServletWebServerFactory factory) {
                super.customize(factory);
                factory.addInitializers(new ServletContextInitializer[]{servletContext -> {
                    FilterRegistration.Dynamic rewriteFilterRegistration = servletContext.addFilter("OCPsoft Rewrite Filter", RewriteFilter.class);
                    rewriteFilterRegistration.setAsyncSupported(true);
                    rewriteFilterRegistration.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
                }});
            }
        };
        bean.getListeners().add(RewriteServletRequestListener.class);
        bean.getListeners().add(RewriteServletContextListener.class);
        return bean;
    }

    @Bean
    public ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public SpringExpressionLanguageProvider rewriteExpressionLanguageProvider() {
        return new SpringExpressionLanguageProvider();
    }
}

