/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.adminfaces;

import com.github.adminfaces.template.config.AdminConfig;
import com.github.adminfaces.template.exception.AccessDeniedException;
import com.github.adminfaces.template.session.AdminServletContextListener;
import com.github.adminfaces.template.session.AdminSession;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.faces.application.ViewExpiredException;
import lombok.Generated;
import org.joinfaces.autoconfigure.adminfaces.AdminConfigWrapper;
import org.joinfaces.autoconfigure.adminfaces.AdminfacesProperties;
import org.joinfaces.autoconfigure.primefaces.Primefaces4_0Properties;
import org.joinfaces.autoconfigure.primefaces.Primefaces5_2Properties;
import org.joinfaces.autoconfigure.primefaces.PrimefacesAutoConfiguration;
import org.joinfaces.autoconfigure.servlet.WebFragmentRegistrationBean;
import org.joinfaces.autoconfigure.servlet.initparams.ServletContextInitParameterProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;

@Configuration
@EnableConfigurationProperties(value={AdminfacesProperties.class})
@ComponentScan(value={"com.github.adminfaces.template.bean", "com.github.adminfaces.template.config", "com.github.adminfaces.template.security"})
@ServletComponentScan(value={"com.github.adminfaces.template.security", "com.github.adminfaces.template.session"})
@ConditionalOnClass(value={AdminSession.class})
@AutoConfigureBefore(value={PrimefacesAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class AdminfacesAutoConfiguration {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminfacesAutoConfiguration.class);
    @Autowired
    private AdminfacesProperties adminfacesProperties;

    @Bean
    public BeanPostProcessor adminfacesPrimeFacesPropertiesPostProcessor() {
        PrimeFacesPropertiesPostProcessor result = new PrimeFacesPropertiesPostProcessor();
        result.setAdminfacesProperties(this.adminfacesProperties);
        return result;
    }

    @Bean
    @Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public AdminSession adminSession() {
        return new AdminSession();
    }

    @Bean
    public WebFragmentRegistrationBean adminTemplateWebFragmentRegistrationBean() {
        WebFragmentRegistrationBean bean = new WebFragmentRegistrationBean();
        bean.getContextParams().put("primefaces.THEME", "admin");
        bean.getErrorPages().add(new ErrorPage(HttpStatus.FORBIDDEN, "/403.xhtml"));
        bean.getErrorPages().add(new ErrorPage(AccessDeniedException.class, "/403.xhtml"));
        try {
            Class<?> accessLocalException = Class.forName("javax.ejb.AccessLocalException");
            bean.getErrorPages().add(new ErrorPage(accessLocalException, "/403.xhtml"));
        }
        catch (ClassNotFoundException accessLocalException) {
            // empty catch block
        }
        bean.getErrorPages().add(new ErrorPage(HttpStatus.NOT_FOUND, "/404.xhtml"));
        bean.getErrorPages().add(new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/500.xhtml"));
        bean.getErrorPages().add(new ErrorPage(Throwable.class, "/500.xhtml"));
        bean.getErrorPages().add(new ErrorPage(ViewExpiredException.class, "/expired.xhtml"));
        try {
            Class<?> optimisticLockException = Class.forName("javax.persistence.OptimisticLockException");
            bean.getErrorPages().add(new ErrorPage(optimisticLockException, "/optimistic.xhtml"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        bean.getListeners().add(AdminServletContextListener.class);
        return bean;
    }

    @Bean
    public WebFragmentRegistrationBean adminThemeWebFragmentRegistrationBean() {
        WebFragmentRegistrationBean bean = new WebFragmentRegistrationBean();
        bean.getContextParams().put("primefaces.FONT_AWESOME", "true");
        return bean;
    }

    static class PrimeFacesPropertiesPostProcessor
    implements BeanPostProcessor {
        private AdminfacesProperties adminfacesProperties;

        PrimeFacesPropertiesPostProcessor() {
        }

        public Object postProcessBeforeInitialization(@Nullable Object bean, @Nullable String beanName) throws BeansException {
            ServletContextInitParameterProperties properties;
            if (bean instanceof Primefaces4_0Properties) {
                properties = (Primefaces4_0Properties)bean;
                log.warn("Changing primefaces theme from '{}' to 'admin'.", (Object)((Primefaces4_0Properties)properties).getTheme());
                ((Primefaces4_0Properties)properties).setTheme("admin");
            }
            if (bean instanceof Primefaces5_2Properties) {
                properties = (Primefaces5_2Properties)bean;
                log.warn("Changing primefaces fontAwesome from 'false' to 'true'.");
                ((Primefaces5_2Properties)properties).setFontAwesome(true);
            }
            if (bean instanceof AdminConfig) {
                AdminConfigWrapper adminConfigWrapper = new AdminConfigWrapper();
                adminConfigWrapper.setAdminfacesProperties(this.adminfacesProperties);
                bean = adminConfigWrapper;
            }
            return bean;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setAdminfacesProperties(AdminfacesProperties adminfacesProperties) {
            this.adminfacesProperties = adminfacesProperties;
        }
    }
}

