/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathScanUtil {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClasspathScanUtil.class);

    public static Set<Class<?>> getClasses(Stream<String> classNames) {
        AtomicInteger missingClasses = new AtomicInteger();
        AtomicInteger missingDependentClasses = new AtomicInteger();
        Set<Class<?>> collect = classNames.map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                missingClasses.incrementAndGet();
                log.debug("Failed to load class {} although it's listed in the prepared scan result.", className);
                log.trace("Stacktrace", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                missingDependentClasses.incrementAndGet();
                log.debug("Failed to load class {} because it's dependency {} is missing.", className, (Object)e.getMessage());
                log.trace("Stacktrace", (Throwable)e);
            }
            catch (LinkageError e) {
                log.warn("Failed to load class {} from prepared scan result", className, (Object)e);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (missingClasses.get() > 0) {
            log.warn("{} classes listed in the prepared scan result could not be found. Set the log-level to debug for more information.", (Object)missingClasses.get());
        }
        if (missingDependentClasses.get() > 0) {
            log.info("{} classes failed to load, because some of their dependencies are missing. Set the log-level to debug for more information.", (Object)missingDependentClasses.get());
        }
        return collect;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ClasspathScanUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

