/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.servlet.initializer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import lombok.Generated;
import org.joinfaces.autoconfigure.ClasspathScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.StopWatch;

public class ServletContainerInitializerRegistrationBean<T extends ServletContainerInitializer>
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServletContainerInitializerRegistrationBean.class);
    private final Class<T> servletContainerInitializerClass;
    private boolean usePreparedScanResult = true;

    public void customize(ConfigurableServletWebServerFactory factory) {
        factory.addInitializers(new ServletContextInitializer[]{servletContext -> {
            ServletContainerInitializer servletContextInitializer = (ServletContainerInitializer)BeanUtils.instantiateClass(this.getServletContainerInitializerClass());
            servletContextInitializer.onStartup(this.getClasses(), servletContext);
        }});
    }

    protected Set<Class<?>> getClasses() {
        return this.findPreparedScanResult().orElseGet(this::performClasspathScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<Set<Class<?>>> findPreparedScanResult() {
        if (!this.isUsePreparedScanResult()) {
            return Optional.empty();
        }
        String resourceName = "META-INF/joinfaces/" + this.getServletContainerInitializerClass().getName() + ".classes";
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            log.debug("No prepared scan-result found for {}", this.getServletContainerInitializerClass());
            return Optional.empty();
        }
        StopWatch stopWatch = new StopWatch(this.getServletContainerInitializerClass().getName());
        stopWatch.start("load scan-result");
        try {
            Optional<Set<Class<?>>> optional;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
            try {
                optional = Optional.of(ClasspathScanUtil.getClasses(bufferedReader.lines()));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Failed to read prepared scan-result {}", (Object)resourceName, (Object)e);
                    Optional<Set<Class<?>>> optional2 = Optional.empty();
                    return optional2;
                }
            }
            bufferedReader.close();
            return optional;
        }
        finally {
            stopWatch.stop();
            log.info("Load scan classes file for {} took {}s", (Object)this.getServletContainerInitializerClass().getName(), (Object)stopWatch.getTotalTimeSeconds());
            if (log.isDebugEnabled()) {
                log.debug(stopWatch.prettyPrint());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Set<Class<?>> performClasspathScan() {
        HandlesTypes handlesTypes = (HandlesTypes)AnnotationUtils.findAnnotation(this.getServletContainerInitializerClass(), HandlesTypes.class);
        if (handlesTypes == null) {
            return null;
        }
        Class[] handledTypes = handlesTypes.value();
        if (handledTypes.length == 0) {
            return null;
        }
        StopWatch stopWatch = new StopWatch(this.getServletContainerInitializerClass().getName());
        stopWatch.start("prepare");
        ClassGraph classGraph = new ClassGraph().enableClassInfo();
        if (Arrays.stream(handledTypes).anyMatch(Class::isAnnotation)) {
            classGraph = classGraph.enableAnnotationInfo();
        }
        classGraph = classGraph.enableExternalClasses().enableSystemPackages().blacklistPackages(new String[]{"java", "jdk", "sun", "javafx", "oracle"}).blacklistPackages(new String[]{"javax.xml", "javax.el", "javax.persistence"}).blacklistModules(new String[]{"java.*", "jdk.*"}).filterClasspathElements(path -> {
            log.debug("Path {}", (Object)path);
            return true;
        });
        HashSet classes = new HashSet();
        stopWatch.stop();
        stopWatch.start("classpath scan");
        try (ScanResult scanResult = classGraph.scan();){
            stopWatch.stop();
            stopWatch.start("collect results");
            for (Class handledType : handledTypes) {
                ClassInfoList classInfos = handledType.isAnnotation() ? scanResult.getClassesWithAnnotation(handledType.getName()) : (handledType.isInterface() ? scanResult.getClassesImplementing(handledType.getName()) : scanResult.getSubclasses(handledType.getName()));
                classes.addAll(classInfos.loadClasses());
            }
            this.handleScanResult(scanResult);
        }
        finally {
            stopWatch.stop();
            log.info("Resolving classes for {} took {}s", (Object)this.getServletContainerInitializerClass().getName(), (Object)stopWatch.getTotalTimeSeconds());
            if (log.isDebugEnabled()) {
                log.debug(stopWatch.prettyPrint());
            }
        }
        return classes.isEmpty() ? null : classes;
    }

    protected void handleScanResult(ScanResult scanResult) {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServletContainerInitializerRegistrationBean(Class<T> servletContainerInitializerClass) {
        this.servletContainerInitializerClass = servletContainerInitializerClass;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Class<T> getServletContainerInitializerClass() {
        return this.servletContainerInitializerClass;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUsePreparedScanResult() {
        return this.usePreparedScanResult;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUsePreparedScanResult(boolean usePreparedScanResult) {
        this.usePreparedScanResult = usePreparedScanResult;
    }
}

