/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.joinfaces.autoconfigure.rewrite.ApplicationContextProvider;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.springframework.context.ApplicationContext;

public class SpringBootServiceEnricher
implements ServiceEnricher {
    public <T> Collection<T> produce(Class<T> type) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        if (applicationContext == null) {
            return Collections.emptyList();
        }
        return applicationContext.getBeanProvider(type).orderedStream().collect(Collectors.toList());
    }

    public <T> void enrich(T service) {
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        if (applicationContext != null) {
            applicationContext.getAutowireCapableBeanFactory().autowireBean(service);
        }
    }
}

