/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.joinfaces.autoconfigure.rewrite.ApplicationContextProvider;
import org.ocpsoft.rewrite.el.spi.ExpressionLanguageProvider;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;

public class SpringBootExpressionLanguageProvider
implements ExpressionLanguageProvider {
    private final ExpressionParser parser = new SpelExpressionParser();
    private EvaluationContext _evaluationContext = null;

    public int priority() {
        return 19;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Object retrieveValue(String expression) throws UnsupportedOperationException {
        try {
            Expression exp = this.parser.parseExpression(expression);
            return exp.getValue(this.getEvaluationContext());
        }
        catch (SpelEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void submitValue(String expression, Object value) throws UnsupportedOperationException {
        try {
            Expression exp = this.parser.parseExpression(expression);
            exp.setValue(this.getEvaluationContext(), value);
        }
        catch (SpelEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Object evaluateMethodExpression(String expression) throws UnsupportedOperationException {
        try {
            String el = expression;
            if (!el.endsWith("()")) {
                el = el + "()";
            }
            Expression exp = this.parser.parseExpression(el);
            return exp.getValue(this.getEvaluationContext());
        }
        catch (SpelEvaluationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public Object evaluateMethodExpression(String expression, Object ... values) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public EvaluationContext getEvaluationContext() {
        if (this._evaluationContext == null) {
            ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
            ConfigurableBeanFactory beanFactory = null;
            if (applicationContext instanceof ConfigurableBeanFactory) {
                beanFactory = (ConfigurableBeanFactory)applicationContext;
            }
            if (beanFactory == null && applicationContext != null && applicationContext.getAutowireCapableBeanFactory() instanceof ConfigurableBeanFactory) {
                beanFactory = (ConfigurableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
            }
            if (beanFactory == null) {
                throw new IllegalStateException("Unable to find a ConfigurableBeanFactory");
            }
            BeanExpressionContext beanEvaluationContext = new BeanExpressionContext(beanFactory, null);
            StandardEvaluationContext sec = new StandardEvaluationContext();
            sec.setRootObject((Object)beanEvaluationContext);
            sec.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
            sec.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
            sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            sec.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)beanEvaluationContext.getBeanFactory()));
            sec.setTypeLocator((TypeLocator)new StandardTypeLocator(beanEvaluationContext.getBeanFactory().getBeanClassLoader()));
            ConversionService conversionService = beanEvaluationContext.getBeanFactory().getConversionService();
            if (conversionService != null) {
                sec.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
            }
            this._evaluationContext = sec;
        }
        return this._evaluationContext;
    }
}

