/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.viewscope;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEventListener;
import lombok.Generated;
import org.joinfaces.autoconfigure.viewscope.DestructionCallbackWrapper;
import org.joinfaces.autoconfigure.viewscope.SessionHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ViewScope
implements Scope {
    public static final String SCOPE_VIEW = "view";
    private final BeanFactory beanFactory;

    public Object get(String name, ObjectFactory objectFactory) {
        return this.getViewRoot().getViewMap().computeIfAbsent(name, k -> objectFactory.getObject());
    }

    public Object remove(String name) {
        UIViewRoot viewRoot = this.getViewRoot();
        Object bean = viewRoot.getViewMap().remove(name);
        viewRoot.getViewListenersForEventClass(PreDestroyViewMapEvent.class).stream().filter(systemEventListener -> systemEventListener instanceof DestructionCallbackWrapper).map(systemEventListener -> (DestructionCallbackWrapper)systemEventListener).filter(destructionCallbackWrapper -> destructionCallbackWrapper.getBeanName().equals(name)).findFirst().ifPresent(destructionCallbackWrapper -> {
            viewRoot.unsubscribeFromViewEvent(PreDestroyViewMapEvent.class, (SystemEventListener)destructionCallbackWrapper);
            this.getSessionHelper().unregister((DestructionCallbackWrapper)destructionCallbackWrapper);
        });
        return bean;
    }

    public String getConversationId() {
        return this.getViewRoot().getViewId();
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        DestructionCallbackWrapper wrapper = new DestructionCallbackWrapper(name, callback);
        this.getViewRoot().subscribeToViewEvent(PreDestroyViewMapEvent.class, (SystemEventListener)wrapper);
        this.getSessionHelper().register(wrapper);
    }

    public Object resolveContextualObject(String key) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        return attributes.resolveReference(key);
    }

    @NonNull
    private UIViewRoot getViewRoot() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException("No FacesContext found.");
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            throw new IllegalStateException("No ViewRoot found");
        }
        return viewRoot;
    }

    private SessionHelper getSessionHelper() {
        return (SessionHelper)this.beanFactory.getBean(SessionHelper.class);
    }

    @Generated
    public ViewScope(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

