/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.viewscope;

import javax.faces.component.UIViewRoot;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class DestructionCallbackWrapper
implements SystemEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DestructionCallbackWrapper.class);
    private final String beanName;
    private Runnable callback;
    private boolean callbackCalled;

    DestructionCallbackWrapper(String beanName, Runnable callback) {
        Assert.hasText((String)beanName, (String)"beanName must not be null or empty");
        Assert.notNull((Object)callback, (String)"callback must not be null");
        this.beanName = beanName;
        this.callback = callback;
    }

    public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
        this.doRunCallback(Source.VIEW);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    void onSessionDestroy() {
        this.doRunCallback(Source.SESSION);
    }

    private synchronized void doRunCallback(Source source) {
        if (!this.isCallbackCalled()) {
            log.info(source.getLogPattern(), (Object)this.getBeanName());
            this.callback.run();
            this.callbackCalled = true;
            this.callback = null;
        }
    }

    @Generated
    public String getBeanName() {
        return this.beanName;
    }

    @Generated
    public Runnable getCallback() {
        return this.callback;
    }

    @Generated
    public boolean isCallbackCalled() {
        return this.callbackCalled;
    }

    private static enum Source {
        VIEW("Calling destruction callbacks for bean {} because the view map is destroyed"),
        SESSION("Calling destruction callbacks for bean {} because the session is destroyed");

        private final String logPattern;

        @Generated
        public String getLogPattern() {
            return this.logPattern;
        }

        @Generated
        private Source(String logPattern) {
            this.logPattern = logPattern;
        }
    }
}

