/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.undertow;

import com.sun.faces.config.ConfigureListener;
import io.undertow.Undertow;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import lombok.Generated;
import org.joinfaces.autoconfigure.undertow.UndertowProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={UndertowProperties.class})
@ConditionalOnClass(value={Undertow.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class UndertowAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UndertowAutoConfiguration.class);
    private final UndertowProperties undertowProperties;

    @Bean
    public WebServerFactoryCustomizer<UndertowServletWebServerFactory> jsfUndertowFactoryCustomizer() {
        return factory -> factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> {
            AccessController.doPrivileged(() -> {
                URLClassLoader jsfClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
                deploymentInfo.setClassLoader((ClassLoader)jsfClassLoader);
                deploymentInfo.setResourceManager((ResourceManager)new ClassPathResourceManager((ClassLoader)jsfClassLoader, this.undertowProperties.getClassPathResource()));
                return null;
            });
            log.info("Setting Undertow classLoader to {} directory", (Object)this.undertowProperties.getClassPathResource());
        }});
    }

    @Generated
    public UndertowAutoConfiguration(UndertowProperties undertowProperties) {
        this.undertowProperties = undertowProperties;
    }

    @Configuration
    @ConditionalOnClass(value={ConfigureListener.class})
    public static class UndertowMojarraAutoConfiguration {
        @Bean
        public WebServerFactoryCustomizer<UndertowServletWebServerFactory> mojarraUndertowFactoryCustomizer() {
            return factory -> factory.addInitializers(new ServletContextInitializer[]{servletContext -> servletContext.addListener(ConfigureListener.class)});
        }
    }
}

