/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.servlet.initparams;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import lombok.Generated;
import org.joinfaces.autoconfigure.servlet.initparams.NestedProperty;
import org.joinfaces.autoconfigure.servlet.initparams.ServletContextInitParameter;
import org.joinfaces.autoconfigure.servlet.initparams.ServletContextInitParameterProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class InitParameterServletContextConfigurer
implements ServletContextInitializer,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InitParameterServletContextConfigurer.class);
    private final List<ServletContextInitParameterProperties> initParameterProperties;
    private final Set<String> visitiedInitParameters;
    private ServletContext servletContext;
    private int order;

    public InitParameterServletContextConfigurer(List<ServletContextInitParameterProperties> initParameterProperties) {
        this.initParameterProperties = initParameterProperties;
        this.visitiedInitParameters = new HashSet<String>();
    }

    public void onStartup(ServletContext servletContext) {
        this.servletContext = servletContext;
        for (ServletContextInitParameterProperties properties : this.initParameterProperties) {
            this.handlePropertiesObject(properties);
        }
    }

    private void handlePropertiesObject(Object properties) {
        Class type = AopUtils.getTargetClass((Object)properties);
        ReflectionUtils.doWithFields((Class)type, field -> this.handlePropertiesField(properties, field), field -> AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, ServletContextInitParameter.class) || AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, NestedProperty.class));
    }

    private void handlePropertiesField(Object properties, Field field) {
        ServletContextInitParameter servletContextInitParameter;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, NestedProperty.class)) {
            ReflectionUtils.makeAccessible((Field)field);
            Object nestedProperties = ReflectionUtils.getField((Field)field, (Object)properties);
            if (nestedProperties != null) {
                this.handlePropertiesObject(nestedProperties);
            } else {
                log.debug("Not visiting nested property {} because its null", (Object)field);
            }
        }
        if ((servletContextInitParameter = (ServletContextInitParameter)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, ServletContextInitParameter.class)) != null) {
            String paramName = servletContextInitParameter.value();
            if (this.visitiedInitParameters.contains(paramName)) {
                log.debug("Not setting '{}' because it was already processed", (Object)paramName);
                return;
            }
            ReflectionUtils.makeAccessible((Field)field);
            Object value = ReflectionUtils.getField((Field)field, (Object)properties);
            if (value == null) {
                log.debug("Not setting '{}' because the value is null", (Object)paramName);
            } else {
                String paramValue = this.convertToString(field, value);
                log.debug("{} = {}", (Object)paramName, (Object)paramValue);
                this.servletContext.setInitParameter(paramName, paramValue);
            }
            this.visitiedInitParameters.add(paramName);
        }
    }

    private String convertToString(Field field, Object value) {
        Class<?> targetType = field.getType();
        if (Collection.class.isAssignableFrom(field.getType())) {
            targetType = InitParameterServletContextConfigurer.resolveCollectionItemType(field);
            if (((Collection)value).isEmpty()) {
                return "";
            }
            ServletContextInitParameter servletContextInitParameter = (ServletContextInitParameter)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, ServletContextInitParameter.class);
            Iterator iterator = ((Collection)value).iterator();
            String firstValue = this.convertToString(targetType, iterator.next());
            StringBuilder sb = new StringBuilder(firstValue);
            while (iterator.hasNext()) {
                String nextValue = this.convertToString(targetType, iterator.next());
                sb.append(servletContextInitParameter.listSeparator()).append(nextValue);
            }
            return sb.toString();
        }
        return this.convertToString(targetType, value);
    }

    private String convertToString(Class<?> targetType, Object value) {
        if (String.class.isAssignableFrom(targetType)) {
            return (String)value;
        }
        if (targetType.isEnum()) {
            return ((Enum)value).name();
        }
        if (Class.class.isAssignableFrom(targetType)) {
            return ((Class)value).getName();
        }
        return value.toString();
    }

    static Class<?> resolveCollectionItemType(Field field) {
        Type genericFieldType = field.getGenericType();
        if (genericFieldType instanceof Class) {
            log.warn("Field {} uses a raw collection type. Assuming Object as item type", (Object)field);
            return Object.class;
        }
        Type actualType = ((ParameterizedType)genericFieldType).getActualTypeArguments()[0];
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        return (Class)((ParameterizedType)actualType).getRawType();
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

