/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joinfaces.autoconfigure.rewrite.ApplicationContextProvider;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringBootBeanNameResolver
implements BeanNameResolver {
    private final Logger log = Logger.getLogger(SpringBootBeanNameResolver.class);

    public String getBeanName(Class<?> clazz) {
        ApplicationContext context = ApplicationContextProvider.applicationContext();
        if (context == null) {
            throw new IllegalStateException("Unable to get current WebApplicationContext");
        }
        Set<String> beanNames = this.resolveBeanNames((ListableBeanFactory)context, clazz);
        if (beanNames == null || beanNames.size() == 0) {
            return null;
        }
        if (beanNames.size() > 1) {
            this.log.warn("Spring knows more than one bean of type [{}]", (Object)clazz.getName());
            return null;
        }
        return beanNames.iterator().next();
    }

    private Set<String> resolveBeanNames(ListableBeanFactory beanFactory, Class<?> clazz) {
        HashSet<String> result = new HashSet<String>();
        Map beanMap = beanFactory.getBeansOfType(clazz);
        if (beanMap != null) {
            for (String name : beanMap.keySet()) {
                if (name == null || name.startsWith("scopedTarget.")) continue;
                result.add(name);
            }
        }
        return result;
    }
}

