/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.javaxfaces;

import java.util.Map;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={FacesContext.class})
public class JsfBeansAutoConfiguration {
    @Bean(value={"application"})
    @ConditionalOnMissingBean(name={"application"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public Object application() {
        return FacesContext.getCurrentInstance().getExternalContext().getContext();
    }

    @Bean(value={"applicationScope"})
    @ConditionalOnMissingBean(name={"applicationScope"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, Object> applicationMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
    }

    @Bean(value={"cookie"})
    @ConditionalOnMissingBean(name={"cookie"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, Object> requestCookieMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestCookieMap();
    }

    @Bean(value={"facesContext"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnMissingBean
    public FacesContext facesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Bean(value={"flash"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnMissingBean
    public Flash flash() {
        return FacesContext.getCurrentInstance().getExternalContext().getFlash();
    }

    @Bean(value={"flowScope"})
    @ConditionalOnMissingBean(name={"flowScope"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<Object, Object> flowScope() {
        return FacesContext.getCurrentInstance().getApplication().getFlowHandler().getCurrentFlowScope();
    }

    @Bean(value={"header"})
    @ConditionalOnMissingBean(name={"header"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, String> headerMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestHeaderMap();
    }

    @Bean(value={"headerValues"})
    @ConditionalOnMissingBean(name={"headerValues"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, String[]> headerValuesMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestHeaderValuesMap();
    }

    @Bean(value={"initParam"})
    @ConditionalOnMissingBean(name={"initParam"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, String> initParameterMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getInitParameterMap();
    }

    @Bean(value={"param"})
    @ConditionalOnMissingBean(name={"param"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, String> requestParameterMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
    }

    @Bean(value={"paramValues"})
    @ConditionalOnMissingBean(name={"paramValues"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, String[]> requestParameterValuesMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterValuesMap();
    }

    @Bean(value={"request"})
    @ConditionalOnMissingBean
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public Object request() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    @Bean(value={"requestScope"})
    @ConditionalOnMissingBean(name={"requestScope"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, Object> requestMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
    }

    @Bean(value={"resource"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnMissingBean
    public ResourceHandler resourceHandler() {
        return FacesContext.getCurrentInstance().getApplication().getResourceHandler();
    }

    @Bean(value={"session"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnMissingBean
    public Object session() {
        return FacesContext.getCurrentInstance().getExternalContext().getSession(false);
    }

    @Bean(value={"sessionScope"})
    @ConditionalOnMissingBean(name={"sessionScope"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Map<String, Object> sessionMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
    }

    @Bean(value={"view"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnMissingBean
    public UIViewRoot viewRoot() {
        return FacesContext.getCurrentInstance().getViewRoot();
    }

    @Bean(value={"viewScope"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    @ConditionalOnMissingBean(name={"viewScope"})
    public Map<String, Object> viewMap() {
        return FacesContext.getCurrentInstance().getViewRoot().getViewMap();
    }

    @Bean(value={"externalContext"})
    @Scope(value="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @ConditionalOnMissingBean
    public ExternalContext externalContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }
}

