/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.util.StringUtil;
import jodd.vtor.Check;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.ValidationContext;
import jodd.vtor.Violation;

public class Vtor {
    public static final String DEFAULT_PROFILE = "default";
    public static final String ALL_PROFILES = "*";
    protected List<Violation> violations;
    protected int severity;
    protected HashSet<String> enabledProfiles;
    protected boolean validateAllProfilesByDefault;

    public static Vtor create() {
        return new Vtor();
    }

    public void addViolation(Violation v) {
        if (v == null) {
            return;
        }
        if (this.violations == null) {
            this.violations = new ArrayList<Violation>();
        }
        this.violations.add(v);
    }

    public void resetViolations() {
        this.violations = null;
    }

    public List<Violation> validate(Object target) {
        return this.validate(ValidationContext.resolveFor(target.getClass()), target);
    }

    public List<Violation> validate(ValidationContext vctx, Object target) {
        return this.validate(vctx, target, null);
    }

    public List<Violation> validate(ValidationContext ctx, Object target, String targetName) {
        for (Map.Entry<String, List<Check>> entry : ctx.map.entrySet()) {
            String name = entry.getKey();
            Object value = BeanUtil.declaredSilent.getProperty(target, name);
            String valueName = targetName != null ? targetName + '.' + name : name;
            ValidationConstraintContext vcc = new ValidationConstraintContext(this, target, valueName);
            for (Check check : entry.getValue()) {
                ValidationConstraint constraint;
                String[] checkProfiles = check.getProfiles();
                if (!this.matchProfiles(checkProfiles) || check.getSeverity() < this.severity || (constraint = check.getConstraint()).isValid(vcc, value)) continue;
                this.addViolation(new Violation(valueName, target, value, check));
            }
        }
        return this.getViolations();
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public boolean isValidateAllProfilesByDefault() {
        return this.validateAllProfilesByDefault;
    }

    public void setValidateAllProfilesByDefault(boolean validateAllProfilesByDefault) {
        this.validateAllProfilesByDefault = validateAllProfilesByDefault;
    }

    public void useProfile(String profile) {
        if (profile == null) {
            return;
        }
        if (this.enabledProfiles == null) {
            this.enabledProfiles = new HashSet();
        }
        this.enabledProfiles.add(profile);
    }

    public void useProfiles(String ... enabledProfiles) {
        if (enabledProfiles == null) {
            return;
        }
        if (this.enabledProfiles == null) {
            this.enabledProfiles = new HashSet();
        }
        Collections.addAll(this.enabledProfiles, enabledProfiles);
    }

    public void resetProfiles() {
        this.enabledProfiles = null;
    }

    protected boolean matchProfiles(String[] checkProfiles) {
        if (checkProfiles != null && checkProfiles.length == 1 && checkProfiles[0].equals(ALL_PROFILES)) {
            return true;
        }
        if (this.enabledProfiles == null || this.enabledProfiles.isEmpty()) {
            if (this.validateAllProfilesByDefault) {
                return true;
            }
            if (checkProfiles == null || checkProfiles.length == 0) {
                return true;
            }
            for (String profile : checkProfiles) {
                if (StringUtil.isEmpty((CharSequence)profile)) {
                    return true;
                }
                if (!profile.equals(DEFAULT_PROFILE)) continue;
                return true;
            }
            return false;
        }
        if (checkProfiles == null || checkProfiles.length == 0) {
            return this.enabledProfiles.contains(DEFAULT_PROFILE);
        }
        boolean result = false;
        for (String profile : checkProfiles) {
            boolean b = true;
            boolean must = false;
            if (StringUtil.isEmpty((CharSequence)profile)) {
                profile = DEFAULT_PROFILE;
            } else if (profile.charAt(0) == '-') {
                profile = profile.substring(1);
                b = false;
            } else if (profile.charAt(0) == '+') {
                profile = profile.substring(1);
                must = true;
            }
            if (this.enabledProfiles.contains(profile)) {
                if (!b) {
                    return false;
                }
                result = true;
                continue;
            }
            if (!must) continue;
            return false;
        }
        return result;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public boolean hasViolations() {
        return this.violations != null;
    }
}

