/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor.constraint;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.constraint.Size;

public class SizeConstraint
implements ValidationConstraint<Size> {
    protected int min;
    protected int max;

    public SizeConstraint() {
    }

    public SizeConstraint(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void configure(Size annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
    }

    @Override
    public boolean isValid(ValidationConstraintContext vcc, Object value) {
        return SizeConstraint.validate(value, this.min, this.max);
    }

    public static boolean validate(Object value, int min, int max) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            int size = ((Collection)value).size();
            return size >= min && size <= max;
        }
        if (value instanceof Map) {
            int size = ((Map)value).size();
            return size >= min && size <= max;
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            return size >= min && size <= max;
        }
        return false;
    }
}

