/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor.constraint;

import jodd.typeconverter.Convert;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.constraint.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeConstraint
implements ValidationConstraint<Range> {
    protected double min;
    protected double max;

    public RangeConstraint() {
    }

    public RangeConstraint(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    @Override
    public void configure(Range annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
    }

    @Override
    public boolean isValid(ValidationConstraintContext vcc, Object value) {
        return RangeConstraint.validate(value, this.min, this.max);
    }

    public static boolean validate(Object value, double min, double max) {
        if (value == null) {
            return true;
        }
        double val = Convert.toDoubleValue((Object)value);
        return val >= min && val <= max;
    }
}

