/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.util.ReflectUtil;
import jodd.vtor.Check;
import jodd.vtor.Constraint;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.VtorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContext {
    private static final String ANN_SEVERITY = "severity";
    private static final String ANN_PROFILES = "profiles";
    protected final Map<String, List<Check>> map = new HashMap<String, List<Check>>();
    private static Map<Class, List<Check>> cache = new HashMap<Class, List<Check>>();

    public void add(Check check) {
        String name = check.getName();
        List<Check> list = this.map.get(name);
        if (list == null) {
            list = new ArrayList<Check>();
            this.map.put(name, list);
        }
        list.add(check);
    }

    public void addAll(List<Check> checkList) {
        for (Check check : checkList) {
            this.add(check);
        }
    }

    public static ValidationContext resolveFor(Class<?> target) {
        ValidationContext vc = new ValidationContext();
        vc.addClassChecks(target);
        return vc;
    }

    public void addClassChecks(Class target) {
        List<Check> list = cache.get(target);
        if (list == null) {
            FieldDescriptor[] fields;
            list = new ArrayList<Check>();
            ClassDescriptor cd = ClassIntrospector.lookup((Class)target);
            for (FieldDescriptor fieldDescriptor : fields = cd.getAllFieldDescriptors()) {
                this.collectFieldAnnotationChecks(list, fieldDescriptor.getField());
            }
            cache.put(target, list);
        }
        this.addAll(list);
    }

    protected void collectFieldAnnotationChecks(List<Check> annChecks, Field field) {
        Annotation[] annotations = field.getAnnotations();
        if (annotations.length > 0) {
            this.collectAnnotationChecks(annChecks, field.getType(), field.getName(), annotations);
        }
    }

    protected void collectAnnotationChecks(List<Check> annChecks, Class targetType, String targetName, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            ValidationConstraint vc;
            Constraint c = annotation.annotationType().getAnnotation(Constraint.class);
            if (c == null) continue;
            Class<? extends ValidationConstraint> constraintClass = c.value();
            try {
                vc = this.newConstraint(constraintClass, targetType);
            }
            catch (Exception ex) {
                throw new VtorException("Unable to create constraint: " + constraintClass.getClass().getName(), ex);
            }
            vc.configure(annotation);
            Check check = new Check(targetName, vc);
            this.copyDefaultCheckProperties(check, annotation);
            annChecks.add(check);
        }
    }

    protected <V extends ValidationConstraint> V newConstraint(Class<V> constraint, Class targetType) throws Exception {
        try {
            Constructor<V> ctor = constraint.getConstructor(new Class[0]);
            return (V)((ValidationConstraint)ctor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException ignore) {
            Constructor<V> ctor = constraint.getConstructor(ValidationContext.class);
            return (V)((ValidationConstraint)ctor.newInstance(ValidationContext.resolveFor(targetType)));
        }
    }

    protected void copyDefaultCheckProperties(Check destCheck, Annotation annotation) {
        Integer severity = (Integer)ReflectUtil.readAnnotationValue((Annotation)annotation, (String)ANN_SEVERITY);
        destCheck.setSeverity(severity);
        String[] profiles = (String[])ReflectUtil.readAnnotationValue((Annotation)annotation, (String)ANN_PROFILES);
        destCheck.setProfiles(profiles);
    }
}

