/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import jodd.core.JoddCore;
import jodd.http.upload.FileUploadFactory;
import jodd.http.upload.MultipartStreamParser;
import jodd.servlet.ServletUtil;

public class MultipartRequest
extends MultipartStreamParser {
    private final HttpServletRequest request;
    private String characterEncoding;
    private static final String MREQ_ATTR_NAME = MultipartRequest.class.getName();

    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public MultipartRequest(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) {
        super(fileUploadFactory);
        this.request = request;
        this.characterEncoding = encoding != null ? encoding : request.getCharacterEncoding();
        if (this.characterEncoding == null) {
            this.characterEncoding = JoddCore.encoding;
        }
    }

    public static MultipartRequest getInstance(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) throws IOException {
        MultipartRequest mreq = (MultipartRequest)((Object)request.getAttribute(MREQ_ATTR_NAME));
        if (mreq == null) {
            mreq = new MultipartRequest(request, fileUploadFactory, encoding);
            request.setAttribute(MREQ_ATTR_NAME, (Object)mreq);
        }
        if (!mreq.isParsed()) {
            mreq.parseRequest();
        }
        return mreq;
    }

    public static MultipartRequest getInstance(HttpServletRequest request) throws IOException {
        return MultipartRequest.getInstance(request, null, null);
    }

    public void parseMultipartRequest() throws IOException {
        this.parseRequestStream((InputStream)this.request.getInputStream(), this.characterEncoding);
    }

    public void parseRequest() throws IOException {
        if (ServletUtil.isMultipartRequest(this.request)) {
            this.parseRequestStream((InputStream)this.request.getInputStream(), this.characterEncoding);
        } else {
            Enumeration names = this.request.getParameterNames();
            while (names.hasMoreElements()) {
                String paramName = (String)names.nextElement();
                String[] values = this.request.getParameterValues(paramName);
                this.putParameters(paramName, values);
            }
        }
    }
}

