/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.MethodParam;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.config.Target;
import jodd.madvoc.meta.Out;
import jodd.madvoc.scope.MadvocScope;
import jodd.util.ClassUtil;

public class Targets {
    private final Target[] targets;

    public Targets(Object actionOrTarget, ScopeData scopeData) {
        this.targets = new Target[]{Target.ofValue(actionOrTarget, scopeData)};
    }

    public Targets(ActionRequest actionRequest) {
        this.targets = this.makeTargets(Target.ofValue(actionRequest.getAction(), actionRequest.getActionRuntime().getScopeData()), actionRequest.getActionRuntime().getMethodParams());
    }

    public void forEachTarget(Consumer<Target> targetConsumer) {
        for (Target target : this.targets) {
            targetConsumer.accept(target);
        }
    }

    public void forEachTargetAndIn(MadvocScope scope, BiConsumer<Target, InjectionPoint> biConsumer) {
        for (Target target : this.targets) {
            ScopeData scopeData = target.scopeData();
            if (scopeData.in() == null) continue;
            for (InjectionPoint in : scopeData.in()) {
                if (in.scope() != scope) continue;
                biConsumer.accept(target, in);
            }
        }
    }

    public void forEachTargetAndOut(MadvocScope scope, BiConsumer<Target, InjectionPoint> biConsumer) {
        for (Target target : this.targets) {
            ScopeData scopeData = target.scopeData();
            if (scopeData.out() == null) continue;
            for (InjectionPoint out : scopeData.out()) {
                if (out.scope() != scope) continue;
                biConsumer.accept(target, out);
            }
        }
    }

    public Object[] extractParametersValues() {
        Object[] values = new Object[this.targets.length - 1];
        for (int i = 1; i < this.targets.length; ++i) {
            values[i - 1] = this.targets[i].value();
        }
        return values;
    }

    protected Target[] makeTargets(Target actionTarget, MethodParam[] methodParams) {
        if (methodParams == null) {
            return new Target[]{actionTarget};
        }
        Target[] target = new Target[methodParams.length + 1];
        target[0] = actionTarget;
        Object action = actionTarget.value();
        for (int i = 0; i < methodParams.length; ++i) {
            Target paramTarget;
            MethodParam methodParam = methodParams[i];
            Class paramType = methodParam.type();
            if (methodParam.annotationType() == null) {
                ScopeData newScopeData = methodParam.scopeData().inspector().inspectClassScopesWithCache(paramType);
                paramTarget = Target.ofValue(this.createActionMethodArgument(paramType, action), newScopeData);
            } else {
                paramTarget = methodParam.annotationType() == Out.class ? Target.ofMethodParam(methodParam, this.createActionMethodArgument(paramType, action)) : Target.ofMethodParam(methodParam, type -> this.createActionMethodArgument((Class)type, action));
            }
            target[i + 1] = paramTarget;
        }
        return target;
    }

    protected Object createActionMethodArgument(Class type, Object action) {
        try {
            if (type.getEnclosingClass() == null || Modifier.isStatic(type.getModifiers())) {
                return ClassUtil.newInstance((Class)type);
            }
            Constructor ctor = type.getDeclaredConstructor(type.getDeclaringClass());
            ctor.setAccessible(true);
            return ctor.newInstance(action);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }
}

