/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.component.ActionPathRewriter;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.AsyncActionExecutor;
import jodd.madvoc.component.MadvocComponentLifecycle;
import jodd.madvoc.component.MadvocControllerCfg;
import jodd.madvoc.component.MadvocEncoding;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.component.ServletContextProvider;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.servlet.ServletUtil;
import jodd.util.ClassUtil;

public class MadvocController
extends MadvocControllerCfg
implements MadvocComponentLifecycle.Ready {
    private static final Logger log = LoggerFactory.getLogger(MadvocController.class);
    @PetiteInject
    protected MadvocEncoding madvocEncoding;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ActionPathRewriter actionPathRewriter;
    @PetiteInject
    protected ResultsManager resultsManager;
    @PetiteInject
    protected ServletContextProvider servletContextProvider;
    @PetiteInject
    protected AsyncActionExecutor asyncActionExecutor;

    @Override
    public void ready() {
        if (this.actionsManager.isAsyncModeOn()) {
            this.asyncActionExecutor.start();
        }
    }

    public ServletContext getApplicationContext() {
        return this.servletContextProvider.get();
    }

    public String invoke(String actionPath, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        String originalActionPath = actionPath;
        boolean characterEncodingSet = false;
        while (actionPath != null) {
            String[] actionPathChunks;
            ActionRuntime actionRuntime;
            String httpMethod = servletRequest.getMethod().toUpperCase();
            if (log.isDebugEnabled()) {
                log.debug("Action path: " + httpMethod + " " + actionPath);
            }
            if ((actionRuntime = this.actionsManager.lookup(httpMethod, actionPathChunks = MadvocUtil.splitPathToChunks(actionPath = this.actionPathRewriter.rewrite(servletRequest, actionPath, httpMethod)))) == null) {
                if (actionPath.endsWith(this.welcomeFile)) {
                    actionPath = actionPath.substring(0, actionPath.length() - (this.welcomeFile.length() - 1));
                    actionPathChunks = MadvocUtil.splitPathToChunks(actionPath);
                    actionRuntime = this.actionsManager.lookup(httpMethod, actionPathChunks);
                }
                if (actionRuntime == null) {
                    return originalActionPath;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Invoke action for '" + actionPath + "' using " + actionRuntime.createActionString());
            }
            if (!characterEncodingSet && this.applyCharacterEncoding) {
                String encoding = this.madvocEncoding.getEncoding();
                if (encoding != null) {
                    servletRequest.setCharacterEncoding(encoding);
                    servletResponse.setCharacterEncoding(encoding);
                }
                characterEncodingSet = true;
            }
            Object action = actionRuntime.isActionHandlerDefined() ? actionRuntime.getActionHandler() : this.createAction(actionRuntime.getActionClass());
            ActionRequest actionRequest = this.createActionRequest(actionPath, actionPathChunks, actionRuntime, action, servletRequest, servletResponse);
            if (actionRuntime.isAsync()) {
                this.asyncActionExecutor.invoke(actionRequest);
            } else {
                actionRequest.invoke();
            }
            actionPath = actionRequest.getNextActionPath();
        }
        return null;
    }

    public void render(ActionRequest actionRequest, Object resultObject) throws Exception {
        ActionResult actionResult = this.resultsManager.lookup(actionRequest, resultObject);
        if (actionResult == null) {
            throw new MadvocException("Action result not found");
        }
        if (this.preventCaching) {
            ServletUtil.preventCaching((HttpServletResponse)actionRequest.getHttpServletResponse());
        }
        log.debug(() -> "Result type: " + actionResult.getClass().getSimpleName());
        actionResult.render(actionRequest, actionRequest.getActionResult());
    }

    protected Object createAction(Class actionClass) {
        try {
            return ClassUtil.newInstance((Class)actionClass);
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid Madvoc action", ex);
        }
    }

    protected ActionRequest createActionRequest(String actionPath, String[] actionPathChunks, ActionRuntime actionRuntime, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return new ActionRequest(this, actionPath, actionPathChunks, actionRuntime, action, servletRequest, servletResponse);
    }
}

