/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.RouteChunk;
import jodd.madvoc.config.Targets;
import jodd.madvoc.macro.PathMacros;
import jodd.madvoc.scope.MadvocScope;
import jodd.util.StringUtil;

public class ActionPathMacroInjector {
    private final MadvocScope madvocScope;

    public ActionPathMacroInjector(MadvocScope bindedScope) {
        this.madvocScope = bindedScope;
    }

    public void inject(ActionRequest actionRequest, Targets targets) {
        ActionRuntime actionRuntime = actionRequest.getActionRuntime();
        RouteChunk routeChunk = actionRuntime.getRouteChunk();
        if (!routeChunk.hasMacrosOnPath()) {
            return;
        }
        String[] actionPath = actionRequest.getActionPathChunks();
        int ndx = actionPath.length - 1;
        RouteChunk chunk = routeChunk;
        while (chunk.parent() != null) {
            PathMacros pathMacros = chunk.pathMacros();
            if (pathMacros != null) {
                this.injectMacros(actionPath[ndx], pathMacros, targets);
            }
            --ndx;
            chunk = chunk.parent();
        }
    }

    private void injectMacros(String actionPath, PathMacros pathMacros, Targets targets) {
        String[] names = pathMacros.names();
        String[] values = pathMacros.extract(actionPath);
        for (int ndx = 0; ndx < values.length; ++ndx) {
            String value = values[ndx];
            if (StringUtil.isEmpty((CharSequence)value)) continue;
            String macroName = names[ndx];
            targets.forEachTargetAndIn(this.madvocScope, (target, in) -> {
                String name = in.matchedName(macroName);
                if (name != null) {
                    target.writeValue(name, (Object)value, true);
                }
            });
        }
    }
}

