/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.RouteChunk;
import jodd.madvoc.macro.PathMacros;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;

public class Routes {
    private static final String ANY_METHOD = "*";
    private final RouteChunk root = new RouteChunk(this, null, "");
    private final ActionsManager actionsManager;
    private RouteChunk anyMethodChunk;

    public Routes(ActionsManager actionsManager) {
        this.actionsManager = actionsManager;
    }

    public RouteChunk registerPath(String method, String path) {
        String[] pathChunks;
        method = method == null ? ANY_METHOD : method.toUpperCase();
        RouteChunk chunk = this.root.findOrCreateChild(method);
        if (method.equals(ANY_METHOD)) {
            this.anyMethodChunk = chunk;
        }
        path = StringUtil.cutSurrounding((String)path, (String)"/");
        for (String pathChunk : pathChunks = StringUtil.splitc((String)path, (char)'/')) {
            chunk = chunk.findOrCreateChild(pathChunk);
        }
        return chunk;
    }

    public ActionRuntime lookup(String method, String[] pathChunks) {
        ActionRuntime actionRuntime;
        while ((actionRuntime = this._lookup(method, pathChunks)) == null) {
            if (this.actionsManager.isStrictRoutePaths()) {
                return null;
            }
            String lastPath = pathChunks[pathChunks.length - 1];
            int lastNdx = lastPath.lastIndexOf(46);
            if (lastNdx == -1) {
                return null;
            }
            String pathExtension = lastPath.substring(lastNdx + 1);
            if (StringUtil.equalsOne((String)pathExtension, (String[])this.actionsManager.getPathExtensionsToStrip()) == -1) {
                return null;
            }
            pathChunks[pathChunks.length - 1] = lastPath.substring(0, lastNdx);
        }
        return actionRuntime;
    }

    private ActionRuntime _lookup(String method, String[] pathChunks) {
        ActionRuntime actionRuntime;
        RouteChunk methodChunk;
        ActionRuntime actionRuntime2;
        if (method != null && (actionRuntime2 = this.lookupFrom(methodChunk = this.root.findOrCreateChild(method = method.toUpperCase()), pathChunks)) != null) {
            return actionRuntime2;
        }
        if (this.anyMethodChunk != null && (actionRuntime = this.lookupFrom(this.anyMethodChunk, pathChunks)) != null) {
            return actionRuntime;
        }
        return null;
    }

    private ActionRuntime lookupFrom(RouteChunk chunk, String[] path) {
        RouteChunk[] children = chunk.children();
        if (children == null) {
            return null;
        }
        for (RouteChunk child : children) {
            ActionRuntime matched = this.match(child, path, 0);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    private ActionRuntime match(RouteChunk chunk, String[] path, int ndx) {
        int maxDeep = path.length - 1;
        if (ndx > maxDeep) {
            return null;
        }
        if (!chunk.match(path[ndx])) {
            return null;
        }
        if (ndx == maxDeep) {
            if (chunk.isEndpoint()) {
                return chunk.value();
            }
            return null;
        }
        RouteChunk[] children = chunk.children();
        if (children == null) {
            return null;
        }
        ActionRuntime matchedRuntime = null;
        for (RouteChunk child : children) {
            ActionRuntime match = this.match(child, path, ndx + 1);
            if (match == null) continue;
            if (matchedRuntime == null) {
                matchedRuntime = match;
                continue;
            }
            if (!matchedRuntime.getRouteChunk().hasMacrosOnPath() || match.getRouteChunk().hasMacrosOnPath()) continue;
            matchedRuntime = match;
        }
        if (matchedRuntime != null) {
            return matchedRuntime;
        }
        return null;
    }

    public PathMacros buildActionPathMacros(String actionPath) {
        if (actionPath.isEmpty()) {
            return null;
        }
        PathMacros pathMacros = this.createPathMacroInstance();
        if (!pathMacros.init(actionPath, this.actionsManager.getPathMacroSeparators())) {
            return null;
        }
        return pathMacros;
    }

    private PathMacros createPathMacroInstance() {
        try {
            return (PathMacros)ClassUtil.newInstance((Class)this.actionsManager.getPathMacroClass());
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }
}

