/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.HashMap;
import java.util.Map;
import jodd.madvoc.MadvocException;
import jodd.util.ArraysUtil;
import jodd.util.StringUtil;

public class RootPackages {
    protected String[] packages;
    protected String[] mappings;
    protected Map<String, String> packagePaths;

    public void addRootPackage(String rootPackage) {
        this.addRootPackage(rootPackage, "");
    }

    public void addRootPackageOf(Class actionClass) {
        this.addRootPackageOf(actionClass, "");
    }

    public void addRootPackage(String rootPackage, String mapping) {
        if (this.packages == null) {
            this.packages = new String[0];
        }
        if (this.mappings == null) {
            this.mappings = new String[0];
        }
        if (mapping.length() > 0) {
            if (!mapping.startsWith("/")) {
                mapping = "/" + mapping;
            }
            if (mapping.endsWith("/")) {
                mapping = StringUtil.substring((String)mapping, (int)0, (int)-1);
            }
        }
        for (int i = 0; i < this.packages.length; ++i) {
            if (!this.packages[i].equals(rootPackage)) continue;
            if (this.mappings[i].equals(mapping)) {
                return;
            }
            throw new MadvocException("Different mappings for the same root package: " + rootPackage);
        }
        this.packages = ArraysUtil.append((String[])this.packages, (String)rootPackage);
        this.mappings = ArraysUtil.append((String[])this.mappings, (String)mapping);
    }

    public void addRootPackageOf(Class actionClass, String mapping) {
        this.addRootPackage(actionClass.getPackage().getName(), mapping);
    }

    public String findRootPackageForActionPath(String actionPath) {
        if (this.mappings == null) {
            return null;
        }
        int ndx = -1;
        int delta = Integer.MAX_VALUE;
        for (int i = 0; i < this.mappings.length; ++i) {
            int distance;
            String mapping = this.mappings[i];
            boolean found = false;
            if (actionPath.equals(mapping)) {
                found = true;
            } else if (actionPath.startsWith(mapping = mapping + "/")) {
                found = true;
            }
            if (!found || (distance = actionPath.length() - mapping.length()) >= delta) continue;
            ndx = i;
            delta = distance;
        }
        if (ndx == -1) {
            return null;
        }
        return this.packages[ndx];
    }

    public String findPackagePathForActionPackage(String actionPackage) {
        String packagePath;
        if (this.packages == null) {
            return null;
        }
        if (this.packagePaths == null) {
            this.packagePaths = new HashMap<String, String>();
        }
        if ((packagePath = this.packagePaths.get(actionPackage)) != null) {
            return packagePath;
        }
        int ndx = -1;
        int delta = Integer.MAX_VALUE;
        for (int i = 0; i < this.packages.length; ++i) {
            int distanceFromTheRoot;
            String rootPackage = this.packages[i];
            if (rootPackage.equals(actionPackage)) {
                ndx = i;
                delta = 0;
                break;
            }
            if (!actionPackage.startsWith(rootPackage = rootPackage + '.') || (distanceFromTheRoot = actionPackage.length() - rootPackage.length()) >= delta) continue;
            ndx = i;
            delta = distanceFromTheRoot;
        }
        if (ndx == -1) {
            return null;
        }
        String packageActionPath = delta == 0 ? "" : StringUtil.substring((String)actionPackage, (int)(-delta - 1), (int)0);
        packageActionPath = packageActionPath.replace('.', '/');
        String result = this.mappings[ndx] + packageActionPath;
        this.packagePaths.put(actionPackage, result);
        return result;
    }

    public String toString() {
        if (this.packages == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.packages.length; ++i) {
            String rootPackage = this.packages[i];
            String mapping = this.mappings[i];
            sb.append(rootPackage).append(" --> ").append(mapping).append("\n");
        }
        return sb.toString();
    }
}

