/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.scope.MadvocScope;

public class HeaderScope
implements MadvocScope {
    @Override
    public void inject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        targets.forEachTargetAndIn(this, (target, in) -> {
            Enumeration headerNames = servletRequest.getHeaders(in.name());
            if (headerNames != null) {
                ArrayList allValues = new ArrayList();
                while (headerNames.hasMoreElements()) {
                    allValues.add(headerNames.nextElement());
                }
                ArrayList value = allValues.size() == 1 ? allValues.get(0) : allValues;
                target.writeValue((InjectionPoint)in, (Object)value, true);
            }
        });
    }

    @Override
    public void inject(ServletContext servletContext, Targets targets) {
    }

    @Override
    public void inject(Targets targets) {
    }

    @Override
    public void outject(ActionRequest actionRequest, Targets targets) {
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        targets.forEachTargetAndOut(this, (target, out) -> {
            String value = (String)target.readValue((InjectionPoint)out);
            if (value != null) {
                servletResponse.setHeader(out.name(), value);
            }
        });
    }
}

