/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.util.ArrayList;
import java.util.HashMap;
import jodd.exception.ExceptionUtil;
import jodd.json.JsonSerializer;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.result.JsonActionResult;
import jodd.net.HttpStatus;

@RenderWith(value=JsonActionResult.class)
public class JsonResult {
    private final String body;
    private int status = 200;
    private String message = "OK";

    public static JsonResult of(String json) {
        return new JsonResult(json);
    }

    public static JsonResult of(Object object) {
        String json = JsonSerializer.create().deep(true).serialize(object);
        return new JsonResult(json);
    }

    public static JsonResult of(HttpStatus httpStatus) {
        return JsonResult.empty().status(httpStatus);
    }

    public static JsonResult of(Exception exception) {
        StackTraceElement[] ste;
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        errorMap.put("message", ExceptionUtil.message((Throwable)exception));
        errorMap.put("error", exception.getClass().getName());
        errorMap.put("cause", exception.getCause() != null ? exception.getCause().getClass().getName() : null);
        ArrayList<String> details = new ArrayList<String>();
        for (StackTraceElement stackTraceElement : ste = ExceptionUtil.getStackTrace((Throwable)exception, null, null)) {
            details.add(stackTraceElement.toString());
        }
        errorMap.put("details", details);
        String json = JsonSerializer.create().deep(true).serialize(errorMap);
        return new JsonResult(json).status((HttpStatus)HttpStatus.error500().internalError());
    }

    public static JsonResult empty() {
        return new JsonResult("");
    }

    public JsonResult(String body) {
        this.body = body;
    }

    public JsonResult status(int status) {
        this.status = status;
        return this;
    }

    public JsonResult status(HttpStatus httpStatus) {
        this.status = httpStatus.status();
        this.message = httpStatus.message();
        return this;
    }

    public JsonResult status(int status, String message) {
        this.status = status;
        this.message = message;
        return this;
    }

    public String value() {
        return this.body;
    }

    public int status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }
}

