/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import jodd.cache.TypeCache;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.meta.Action;
import jodd.madvoc.meta.ActionAnnotationValues;
import jodd.madvoc.meta.ActionConfiguredBy;
import jodd.petite.meta.PetiteInject;
import jodd.util.ArraysUtil;
import jodd.util.annotation.AnnotationParser;

public class ActionConfigManager {
    private final TypeCache<ActionConfig> actionConfigs = TypeCache.createDefault();
    private AnnotationParser[] annotationParsers = new AnnotationParser[0];
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;

    public void registerAnnotation(Class<? extends Annotation> annotationType) {
        ActionConfiguredBy actionConfiguredBy = annotationType.getAnnotation(ActionConfiguredBy.class);
        if (actionConfiguredBy == null) {
            throw new MadvocException("Action annotation is missing it's " + ActionConfiguredBy.class.getSimpleName() + " configuration.");
        }
        this.bindAnnotationConfig(annotationType, actionConfiguredBy.value());
    }

    public void bindAnnotationConfig(Class<? extends Annotation> annotationType, Class<? extends ActionConfig> actionConfigClass) {
        ActionConfig actionConfig = this.registerNewActionConfiguration(actionConfigClass);
        this.actionConfigs.put(annotationType, (Object)actionConfig);
        for (AnnotationParser annotationParser : this.annotationParsers) {
            if (!annotationType.equals(annotationParser.getAnnotationType())) continue;
            return;
        }
        this.annotationParsers = (AnnotationParser[])ArraysUtil.append((Object[])this.annotationParsers, (Object)new AnnotationParser(annotationType, Action.class));
    }

    protected ActionConfig registerNewActionConfiguration(Class<? extends ActionConfig> actionConfigClass) {
        ActionConfig newActionConfig = this.createActionConfig(actionConfigClass);
        this.actionConfigs.put(actionConfigClass, (Object)newActionConfig);
        return newActionConfig;
    }

    public ActionConfig lookup(Class actionTypeOrAnnotationType) {
        ActionConfig actionConfig = (ActionConfig)this.actionConfigs.get(actionTypeOrAnnotationType);
        if (actionConfig == null) {
            throw new MadvocException("ActionConfiguration not registered:" + actionTypeOrAnnotationType.getName());
        }
        return actionConfig;
    }

    public <T extends ActionConfig> void with(Class<T> actionConfigType, Consumer<T> actionConfigConsumer) {
        ActionConfig actionConfig = this.lookup(actionConfigType);
        actionConfigConsumer.accept(actionConfig);
    }

    public boolean hasActionAnnotationOn(AnnotatedElement annotatedElement) {
        for (AnnotationParser annotationParser : this.annotationParsers) {
            if (!annotationParser.hasAnnotationOn(annotatedElement)) continue;
            return true;
        }
        return false;
    }

    public ActionAnnotationValues readAnnotationValue(AnnotatedElement annotatedElement) {
        for (AnnotationParser annotationParser : this.annotationParsers) {
            if (!annotationParser.hasAnnotationOn(annotatedElement)) continue;
            return ActionAnnotationValues.of(annotationParser, annotatedElement);
        }
        return null;
    }

    protected ActionConfig createActionConfig(Class<? extends ActionConfig> actionConfigClass) {
        try {
            Constructor<? extends ActionConfig> ctor = actionConfigClass.getDeclaredConstructor(new Class[0]);
            ActionConfig actionConfig = ctor.newInstance(new Object[0]);
            this.contextInjectorComponent.injectContext(actionConfig);
            return actionConfig;
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid action configuration class: " + actionConfigClass.getSimpleName(), ex);
        }
    }
}

