/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jodd.io.upload.FileUpload;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.component.MadvocEncoding;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.scope.ActionPathMacroInjector;
import jodd.madvoc.scope.InstancesInjector;
import jodd.madvoc.scope.MadvocScope;
import jodd.madvoc.scope.RequestScopeCfg;
import jodd.petite.meta.PetiteInject;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;
import jodd.util.StringUtil;

public class RequestScope
extends RequestScopeCfg
implements MadvocScope {
    @PetiteInject
    MadvocEncoding madvocEncoding;
    protected final ActionPathMacroInjector actionPathMacroInjector = new ActionPathMacroInjector(this);
    protected final InstancesInjector instancesInjector = new InstancesInjector(this);

    @Override
    public void inject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        this.instancesInjector.inject(actionRequest, targets);
        if (this.injectAttributes) {
            this.injectAttributes(servletRequest, targets);
        }
        if (this.injectParameters) {
            this.injectParameters(servletRequest, targets);
            this.injectUploadedFiles(servletRequest, targets);
        }
        this.actionPathMacroInjector.inject(actionRequest, targets);
    }

    @Override
    public void inject(ServletContext servletContext, Targets targets) {
    }

    @Override
    public void inject(Targets targets) {
    }

    protected void injectAttributes(HttpServletRequest servletRequest, Targets targets) {
        Enumeration attributeNames = servletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            targets.forEachTargetAndIn(this, (target, in) -> {
                String name = in.matchedName(attrName);
                if (name != null) {
                    Object attrValue = servletRequest.getAttribute(attrName);
                    target.writeValue(name, attrValue, true);
                }
            });
        }
    }

    protected void injectParameters(HttpServletRequest servletRequest, Targets targets) {
        boolean encode = this.encodeGetParams && servletRequest.getMethod().equals("GET");
        Enumeration paramNames = servletRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            targets.forEachTargetAndIn(this, (target, in) -> {
                String name = in.matchedName(paramName);
                if (name != null) {
                    String[] paramValues = servletRequest.getParameterValues(paramName);
                    if ((paramValues = ServletUtil.prepareParameters((String[])paramValues, (boolean)this.treatEmptyParamsAsNull, (boolean)this.ignoreEmptyRequestParams)) != null) {
                        if (encode) {
                            for (int j = 0; j < paramValues.length; ++j) {
                                String p = paramValues[j];
                                if (p == null) continue;
                                String encoding = this.madvocEncoding.getEncoding();
                                paramValues[j] = StringUtil.convertCharset((String)p, (String)"ISO-8859-1", (String)encoding);
                            }
                        }
                        String[] value = paramValues.length != 1 ? paramValues : paramValues[0];
                        target.writeValue(name, (Object)value, true);
                    }
                }
            });
        }
    }

    protected void injectUploadedFiles(HttpServletRequest servletRequest, Targets targets) {
        if (!(servletRequest instanceof MultipartRequestWrapper)) {
            return;
        }
        MultipartRequestWrapper multipartRequest = (MultipartRequestWrapper)servletRequest;
        if (!multipartRequest.isMultipart()) {
            return;
        }
        Enumeration paramNames = multipartRequest.getFileParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            targets.forEachTargetAndIn(this, (target, in) -> {
                String name = in.matchedName(paramName);
                if (name != null) {
                    FileUpload paramValues = multipartRequest.getFiles(paramName);
                    if (this.ignoreInvalidUploadFiles) {
                        for (int j = 0; j < ((FileUpload[])paramValues).length; ++j) {
                            FileUpload paramValue = paramValues[j];
                            if (paramValue.isValid() && paramValue.isUploaded()) continue;
                            paramValues[j] = null;
                        }
                    }
                    FileUpload value = ((FileUpload[])paramValues).length == 1 ? paramValues[0] : paramValues;
                    target.writeValue(name, (Object)value, true);
                }
            });
        }
    }

    @Override
    public void outject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        targets.forEachTargetAndOut(this, (target, out) -> {
            Object value = target.readValue((InjectionPoint)out);
            servletRequest.setAttribute(out.name(), value);
        });
    }
}

