/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ResponseException;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.JsonResult;
import jodd.net.HttpStatus;

public class JsonErrorInterceptor
implements ActionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JsonErrorInterceptor.class);

    @Override
    public Object intercept(ActionRequest actionRequest) {
        try {
            return actionRequest.invoke();
        }
        catch (ResponseException rex) {
            return JsonResult.of(HttpStatus.of((int)rex.getStatus(), (String)rex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Action execution failed:", (Throwable)ex);
            return JsonResult.of(ex);
        }
    }
}

