/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.net.MalformedURLException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.ScopeType;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Scope;
import jodd.madvoc.result.AbstractTemplateViewActionResult;
import jodd.servlet.DispatcherUtil;

public class ServletDispatcherActionResult
extends AbstractTemplateViewActionResult {
    private static final Logger log = LoggerFactory.getLogger(ServletDispatcherActionResult.class);
    @In
    @Scope(value=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;

    @Override
    protected void renderView(ActionRequest actionRequest, String target) throws Exception {
        HttpServletRequest request = actionRequest.getHttpServletRequest();
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        RequestDispatcher dispatcher = request.getRequestDispatcher(target);
        if (dispatcher == null) {
            response.sendError(404, "Result not found: " + target);
            return;
        }
        if (DispatcherUtil.isPageIncluded((HttpServletRequest)request, (HttpServletResponse)response)) {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    @Override
    protected String locateTarget(ActionRequest actionRequest, String path) {
        if (path.endsWith("/")) {
            path = path + this.madvocConfig.getDefaultViewPageName();
        }
        for (String ext : this.madvocConfig.getDefaultViewExtensions()) {
            String target = path + ext;
            if (!this.targetExists(actionRequest, target)) continue;
            return target;
        }
        return null;
    }

    protected boolean targetExists(ActionRequest actionRequest, String target) {
        if (log.isDebugEnabled()) {
            log.debug("target check: " + target);
        }
        ServletContext servletContext = actionRequest.getHttpServletRequest().getServletContext();
        try {
            return servletContext.getResource(target) != null;
        }
        catch (MalformedURLException ignore) {
            return false;
        }
    }
}

